/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.action.ImportExportPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.utils.GestionDevise;

public class ImportExportUtils {
    private static void appendAt(int index, String value, StringBuffer buf) {
        if (buf.length() < index) {
            int size = index - buf.length() - 1;
            int i = 0;
            while (i < size) {
                buf.append(' ');
                ++i;
            }
        }
        buf.append(value);
    }

    public static void exportData(ImportExportPanel panel) {
        File file = new File(panel.getPathFile());
        try {
            BufferedOutputStream bufOut = new BufferedOutputStream(new FileOutputStream(file));
            String s = panel.getFormatDate();
            SimpleDateFormat dateFormat = new SimpleDateFormat(s);
            SQLBase base = panel.getTable2Import().getBase();
            SQLSelect sel = new SQLSelect(base);
            int i = 0;
            while (i < panel.getModel().getRowCount()) {
                SQLField f = panel.getModel().getFieldForIndex(i);
                sel.addSelect(f);
                ++i;
            }
            List l = (List)base.getDataSource().execute(sel.asString(), new ArrayListHandler());
            System.err.println(sel.asString());
            if (l != null) {
                int i2 = 0;
                while (i2 < l.size()) {
                    StringBuffer line = new StringBuffer(0);
                    Object[] tmp = (Object[])l.get(i2);
                    ImportExportUtils.appendAt(0, tmp[0].toString().trim(), line);
                    ImportExportUtils.appendAt(100, tmp[1].toString().trim(), line);
                    ImportExportUtils.appendAt(105, tmp[2].toString().trim(), line);
                    Date d = (Date)tmp[3];
                    ImportExportUtils.appendAt(117, dateFormat.format(d), line);
                    Long debit = new Long(tmp[4].toString().trim());
                    ImportExportUtils.appendAt(127, GestionDevise.currencyToStandardStringExport(debit, 15), line);
                    Long credit = new Long(tmp[5].toString().trim());
                    ImportExportUtils.appendAt(142, GestionDevise.currencyToStandardStringExport(credit, 15), line);
                    ImportExportUtils.appendAt(157, tmp[6].toString().trim(), line);
                    ImportExportUtils.appendAt(162, "\n", line);
                    try {
                        bufOut.write(line.toString().getBytes());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i2;
                }
            }
            try {
                bufOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Vector parseLine(String line, char delim, char englob) {
        Vector<String> result = new Vector<String>();
        boolean englobed = false;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '\\' && i + 1 < line.length()) {
                buffer.append(line.charAt(i + 1));
                ++i;
            } else if (!englobed && line.charAt(i) == englob) {
                englobed = true;
            } else if (englobed && line.charAt(i) == englob) {
                englobed = false;
            } else if (!englobed && line.charAt(i) == delim) {
                result.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(line.charAt(i));
            }
            ++i;
        }
        result.add(buffer.toString());
        return result;
    }

    public static Vector parseLine(String line, int[] delim) {
        Vector<String> result = new Vector<String>();
        int left = 0;
        int i = 0;
        while (i < delim.length) {
            result.add(line.substring(left, left + delim[i]));
            left += delim[i];
            ++i;
        }
        return result;
    }

    public static void importData(final ImportExportPanel panel, final JProgressBar bar) {
        new Thread(){

            @Override
            public void run() {
                File f = new File(panel.getPathFile());
                int nbLine = 0;
                int lineNumber = 0;
                bar.setStringPainted(false);
                try {
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    while (br.readLine() != null) {
                        ++nbLine;
                    }
                    bar.setMaximum(nbLine);
                    br.close();
                    br = new BufferedReader(new FileReader(f));
                    String line = br.readLine();
                    Vector<SQLRowValues> listRowVals = new Vector<SQLRowValues>();
                    while (line != null) {
                        SQLRowValues rowVals = new SQLRowValues(panel.getTable2Import());
                        final int lineNumberTmp = lineNumber++;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                bar.setValue(lineNumberTmp);
                            }
                        });
                        ImportExportUtils.importValues(line, rowVals, panel);
                        listRowVals.add(rowVals);
                        line = br.readLine();
                    }
                    br.close();
                    System.err.println("Insertion des rowValues");
                    for (SQLRowValues r : listRowVals) {
                        try {
                            r.commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (FileNotFoundException fnotFnd) {
                    System.err.println("Le chemin du fichier est incorrect!");
                    fnotFnd.printStackTrace();
                }
                catch (IOException e) {
                    System.err.println("Erreur lors de l'importation du fichier " + f.getName() + " \u00e0 la ligne " + lineNumber);
                    e.printStackTrace();
                }
                bar.setValue(nbLine);
                bar.setStringPainted(true);
                bar.setString("Importation termin\u00e9e.");
                System.err.println("Fin de l'importation.");
            }
        }.start();
    }

    private static void importValues(String line, SQLRowValues vals, ImportExportPanel panel) {
        Vector v = panel.isLongueurFixeSelected() ? ImportExportUtils.parseLine(line, panel.getModel().getDelimiteur()) : ImportExportUtils.parseLine(line, panel.getSeparator().charAt(0), '\"');
        System.err.println("Value to import -->  " + v);
        int i = 0;
        while (i < v.size()) {
            String value = v.get(i).toString().trim();
            Class c = panel.getModel().getClassForIndex(i);
            String fieldName = panel.getModel().getFieldNameForIndex(i);
            if (value != null && value.length() > 0) {
                if (panel.getModel().getTableNameForIndex(i).equalsIgnoreCase(vals.getTable().getName())) {
                    if (c == Float.class) {
                        System.err.println("Put Float " + value);
                        value = value.replace(',', '.');
                        vals.put(fieldName, new Float(value));
                    } else if (c == BigInteger.class || c == Long.class) {
                        System.err.println("Put Long " + value);
                        vals.put(fieldName, new Long(GestionDevise.parseLongCurrency(value)));
                    } else {
                        vals.put(fieldName, value);
                    }
                } else {
                    Object valueObject;
                    SQLField f = panel.getModel().getFieldForIndex(i);
                    Map m = ImportExportUtils.addFillMapForeignField(f);
                    if (m.get(valueObject = c == Float.class ? new Float(value.replace(',', '.')) : (c == BigInteger.class ? new Long(GestionDevise.parseLongCurrency(value)) : (c == Integer.class ? new Integer(value) : new String(value)))) == null) {
                        SQLRowValues nouvRowForeign = new SQLRowValues(f.getTable());
                        nouvRowForeign.put(f.getName(), valueObject);
                        try {
                            SQLRow rowForeign = nouvRowForeign.insert();
                            m.put(valueObject, rowForeign.getObject(f.getTable().getKey().getName()));
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    Set<SQLField> s = vals.getTable().getForeignKeys(f.getTable().getName());
                    for (SQLField field : s) {
                        vals.put(field.getName(), m.get(valueObject));
                    }
                }
            }
            ++i;
        }
    }

    private static Map addFillMapForeignField(SQLField f) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        SQLSelect selAllTaxe = new SQLSelect(base);
        selAllTaxe.addSelect(f.getTable().getKey());
        selAllTaxe.addSelect(f);
        String reqAllTaxe = selAllTaxe.asString();
        List l = (List)base.getDataSource().execute(reqAllTaxe, new ArrayListHandler());
        for (Object[] tmp : l) {
            m.put(tmp[1], tmp[0]);
        }
        return m;
    }

    public static void main(String[] args) {
        File f = new File("C:\\Documents and Settings\\Administrateur\\Mes documents\\ExportDelim.txt");
        try {
            String s;
            BufferedReader buf = new BufferedReader(new FileReader(f));
            while ((s = buf.readLine()) != null) {
                System.err.println(ImportExportUtils.parseLine(s, ',', '\''));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

