/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.model.ImportModel;
import org.openconcerto.sql.model.SQLTable;

public class ImportExportPanel
extends JPanel {
    private JTable table;
    private SQLTable table2Import;
    private ImportModel model;
    private JTextField textPathFic;
    private JTextField textFormatDate;
    private JRadioButton radioSep = new JRadioButton("S\u00e9parateur");
    private JRadioButton radioLongueurFixe = new JRadioButton("Longueur fixe");
    private JTextField textSep = new JTextField(1);

    public ImportExportPanel(SQLTable table2Import, List fields) {
        this(table2Import, fields, false);
    }

    public ImportExportPanel(SQLTable table2Import, List fields, boolean export) {
        this.table2Import = table2Import;
        final Date dateDay = new Date();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 2;
        c.gridheight = 1;
        JLabel labelImport = export ? new JLabel("Fichier de sauvegarde") : new JLabel("Fichier d'importation");
        this.add((Component)labelImport, c);
        this.textPathFic = new JTextField();
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)this.textPathFic, c);
        c.weightx = 0.0;
        c.fill = 0;
        JButton boutonChooseFile = new JButton("...");
        this.add((Component)boutonChooseFile, c);
        boutonChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDialog fileDiag = new FileDialog((Frame)((JFrame)SwingUtilities.getRoot(ImportExportPanel.this)), "S\u00e9lection du fichier \u00e0 importer", 0);
                fileDiag.pack();
                fileDiag.setVisible(true);
                String nom = fileDiag.getFile();
                if (nom != null) {
                    ImportExportPanel.this.textPathFic.setText(String.valueOf(fileDiag.getDirectory()) + fileDiag.getFile());
                }
            }
        });
        c.gridwidth = 2;
        c.fill = 2;
        JLabel labelDate = new JLabel("Format des dates");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelDate, c);
        this.textFormatDate = new JTextField();
        c.gridwidth = 1;
        c.gridx = -1;
        c.weightx = 1.0;
        this.add((Component)this.textFormatDate, c);
        final JLabel labelDateTips = new JLabel();
        c.gridx = -1;
        c.weightx = 0.0;
        this.add((Component)labelDateTips, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)this.radioSep, c);
        ++c.gridx;
        this.add((Component)this.textSep, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.radioLongueurFixe, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioLongueurFixe);
        group.add(this.radioSep);
        this.radioSep.setSelected(true);
        JButton up = new JButton("UP");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.add((Component)up, c);
        up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectRow = ImportExportPanel.this.table.getSelectedRow();
                selectRow = ImportExportPanel.this.model.upField(selectRow);
                ImportExportPanel.this.table.setRowSelectionInterval(selectRow, selectRow);
            }
        });
        JButton down = new JButton("DOWN");
        c.gridx = -1;
        this.add((Component)down, c);
        down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectRow = ImportExportPanel.this.table.getSelectedRow();
                selectRow = ImportExportPanel.this.model.downField(selectRow);
                ImportExportPanel.this.table.setRowSelectionInterval(selectRow, selectRow);
            }
        });
        this.model = new ImportModel(fields);
        this.table = new JTable(this.model);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        JScrollPane scroll = new JScrollPane(this.table);
        Dimension d = this.table.getPreferredSize().height > 200 ? new Dimension(scroll.getPreferredSize().width, 200) : new Dimension(scroll.getPreferredSize().width, this.table.getPreferredSize().height + 30);
        scroll.setPreferredSize(d);
        this.add((Component)scroll, c);
        this.textFormatDate.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportExportPanel.this.setLabelDate(labelDateTips, dateDay);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportExportPanel.this.setLabelDate(labelDateTips, dateDay);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImportExportPanel.this.setLabelDate(labelDateTips, dateDay);
            }
        });
        this.textFormatDate.setText("yyyy-MM-dd");
    }

    private void setLabelDate(JLabel label, Date d) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.textFormatDate.getText());
            label.setText("Ex : " + dateFormat.format(d));
        }
        catch (IllegalArgumentException e) {
            label.setText("format invalide");
            e.printStackTrace();
        }
    }

    public boolean isLongueurFixeSelected() {
        return this.radioLongueurFixe.isSelected();
    }

    public String getSeparator() {
        return this.textSep.getText();
    }

    public String getPathFile() {
        return this.textPathFic.getText();
    }

    public ImportModel getModel() {
        return this.model;
    }

    public String getFormatDate() {
        return this.textFormatDate.getText();
    }

    public SQLTable getTable2Import() {
        return this.table2Import;
    }
}

