/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.SystemInfoPanel;
import org.openconcerto.utils.ProductInfo;

public final class AboutAction
extends AbstractAction {
    private static final AboutAction instance = new AboutAction();

    public static AboutAction getInstance() {
        return instance;
    }

    private AboutAction() {
        super("Informations");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JFrame frame = new JFrame((String)this.getValue("Name"));
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        panel.add((Component)this.createTitle("Logiciel"), c);
        ++c.gridy;
        panel.add((Component)this.createSoftwareInfoPanel(), c);
        ++c.gridy;
        panel.add((Component)this.createTitle("Informations syst\u00e8me"), c);
        ++c.gridy;
        panel.add((Component)new SystemInfoPanel(), c);
        JScrollPane contentPane = new JScrollPane(panel);
        frame.setContentPane(contentPane);
        frame.pack();
        Dimension size = frame.getSize();
        Dimension maxSize = new Dimension(size.width, 700);
        if (size.height > maxSize.height) {
            frame.setMinimumSize(maxSize);
            frame.setPreferredSize(maxSize);
            frame.setSize(maxSize);
        } else {
            frame.setMinimumSize(size);
            frame.setPreferredSize(size);
            frame.setSize(size);
        }
        Dimension maximumSize = maxSize;
        frame.setMaximumSize(maximumSize);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private JLabel createTitle(String text) {
        JLabel res = new JLabel(text);
        Font font = res.getFont();
        res.setFont(font.deriveFont(font.getSize2D() * 1.2f).deriveFont(1));
        return res;
    }

    private JPanel createSoftwareInfoPanel() {
        JPanel res = new JPanel();
        FormLayouter lay = new FormLayouter(res, 1);
        ComptaPropsConfiguration conf = (ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance();
        lay.add("Nom de l'application", new JLabel(conf.getAppName()));
        String version = "Version inconnue";
        try {
            version = ProductInfo.getInstance().getProps().getProperty("VERSION", version);
        }
        catch (Exception e) {
            System.err.println("Error reading product.properties");
        }
        lay.add("Version de l'application", new JLabel(version));
        if (conf.isUsingSSH()) {
            lay.add("Liaison s\u00e9curis\u00e9e", new JLabel(conf.getWanHostAndPort()));
        }
        lay.add("URL de base de donn\u00e9es", new JLabel(Configuration.getInstance().getSystemRoot().getDataSource().getUrl()));
        return res;
    }
}

