/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;

public class ScriptOrFnNode
extends Node.Scope {
    private int encodedSourceStart;
    private int encodedSourceEnd;
    private String sourceName;
    private int endLineno = -1;
    private ObjArray functions;
    private ObjArray regexps;
    private ArrayList symbols = new ArrayList(4);
    private int paramCount = 0;
    private String[] variableNames;
    private boolean[] isConsts;
    private Object compilerData;
    private int tempNumber = 0;

    public ScriptOrFnNode(int nodeType) {
        super(nodeType);
        this.setParent(null);
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public final int getEncodedSourceStart() {
        return this.encodedSourceStart;
    }

    public final int getEncodedSourceEnd() {
        return this.encodedSourceEnd;
    }

    public final void setEncodedSourceBounds(int start, int end2) {
        this.encodedSourceStart = start;
        this.encodedSourceEnd = end2;
    }

    public final int getBaseLineno() {
        return this.lineno;
    }

    public final void setBaseLineno(int lineno) {
        if (lineno < 0 || this.lineno >= 0) {
            Kit.codeBug();
        }
        this.lineno = lineno;
    }

    public final int getEndLineno() {
        return this.endLineno;
    }

    public final void setEndLineno(int lineno) {
        if (lineno < 0 || this.endLineno >= 0) {
            Kit.codeBug();
        }
        this.endLineno = lineno;
    }

    public final int getFunctionCount() {
        if (this.functions == null) {
            return 0;
        }
        return this.functions.size();
    }

    public final FunctionNode getFunctionNode(int i) {
        return (FunctionNode)this.functions.get(i);
    }

    public final int addFunction(FunctionNode fnNode) {
        if (fnNode == null) {
            Kit.codeBug();
        }
        if (this.functions == null) {
            this.functions = new ObjArray();
        }
        this.functions.add(fnNode);
        return this.functions.size() - 1;
    }

    public final int getRegexpCount() {
        if (this.regexps == null) {
            return 0;
        }
        return this.regexps.size() / 2;
    }

    public final String getRegexpString(int index) {
        return (String)this.regexps.get(index * 2);
    }

    public final String getRegexpFlags(int index) {
        return (String)this.regexps.get(index * 2 + 1);
    }

    public final int addRegexp(String string, String flags) {
        if (string == null) {
            Kit.codeBug();
        }
        if (this.regexps == null) {
            this.regexps = new ObjArray();
        }
        this.regexps.add(string);
        this.regexps.add(flags);
        return this.regexps.size() / 2 - 1;
    }

    public int getIndexForNameNode(Node nameNode) {
        Node.Symbol symbol;
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        Node.Scope node = nameNode.getScope();
        Node.Symbol symbol2 = symbol = node == null ? null : node.getSymbol(nameNode.getString());
        if (symbol == null) {
            return -1;
        }
        return symbol.index;
    }

    public final String getParamOrVarName(int index) {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.variableNames[index];
    }

    public final int getParamCount() {
        return this.paramCount;
    }

    public final int getParamAndVarCount() {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.symbols.size();
    }

    public final String[] getParamAndVarNames() {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.variableNames;
    }

    public final boolean[] getParamAndVarConst() {
        if (this.variableNames == null) {
            throw Kit.codeBug();
        }
        return this.isConsts;
    }

    void addSymbol(Node.Symbol symbol) {
        if (this.variableNames != null) {
            throw Kit.codeBug();
        }
        if (symbol.declType == 86) {
            ++this.paramCount;
        }
        this.symbols.add(symbol);
    }

    void flattenSymbolTable(boolean flattenAllTables) {
        if (!flattenAllTables) {
            ArrayList<Node.Symbol> newSymbols = new ArrayList<Node.Symbol>();
            if (this.symbolTable != null) {
                for (int i = 0; i < this.symbols.size(); ++i) {
                    Node.Symbol symbol = (Node.Symbol)this.symbols.get(i);
                    if (symbol.containingTable != this) continue;
                    newSymbols.add(symbol);
                }
            }
            this.symbols = newSymbols;
        }
        this.variableNames = new String[this.symbols.size()];
        this.isConsts = new boolean[this.symbols.size()];
        int i = 0;
        while (i < this.symbols.size()) {
            Node.Symbol symbol = (Node.Symbol)this.symbols.get(i);
            this.variableNames[i] = symbol.name;
            this.isConsts[i] = symbol.declType == 153;
            symbol.index = i++;
        }
    }

    public final Object getCompilerData() {
        return this.compilerData;
    }

    public final void setCompilerData(Object data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerData != null) {
            throw new IllegalStateException();
        }
        this.compilerData = data;
    }

    public String getNextTempName() {
        return "$" + this.tempNumber++;
    }
}

