/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODFrame;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.StyleProperties;

public final class ValueHelper {
    public static final Color TRANSPARENT = StyleProperties.TRANSPARENT;
    private static final Map<String, Color> colors = new HashMap<String, Color>();

    public static final int getLength(String string) {
        return Math.round(ODFrame.parseLength(string, LengthUnit.MM) * 1000.0f);
    }

    public static final boolean getBoolean(String string) {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(string + " not a boolean value");
    }

    public static final Color getColor(String string) {
        if (string == null) {
            return null;
        }
        Color color = colors.get(string);
        if (color != null) {
            return color;
        }
        color = string.equals("transparent") ? TRANSPARENT : OOUtils.decodeRGB(string);
        colors.put(string, color);
        return color;
    }

    static {
        colors.put("maroon", new Color(128, 0, 0));
        colors.put("red", Color.RED);
        colors.put("orange", new Color(255, 165, 0));
        colors.put("yellow", Color.YELLOW);
        colors.put("olive", new Color(128, 128, 0));
        colors.put("purple", new Color(128, 0, 128));
        colors.put("fuchsia", Color.MAGENTA);
        colors.put("white", Color.WHITE);
        colors.put("lime", Color.GREEN);
        colors.put("green", new Color(0, 128, 0));
        colors.put("navy", new Color(0, 0, 128));
        colors.put("blue", Color.BLUE);
        colors.put("aqua", Color.CYAN);
        colors.put("teal", new Color(0, 128, 128));
        colors.put("black", Color.BLACK);
        colors.put("silver", Color.LIGHT_GRAY);
        colors.put("gray", Color.GRAY);
    }
}

