/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.util.SimpleXMLPath;
import org.jopendocument.util.cc.IPredicate;

public final class Step<T> {
    private final Axis axis;
    private final String name;
    private final String ns;
    private final Class<T> clazz;
    private final SimpleXMLPath.Node<T> node;
    private final IPredicate<T> pred;

    public static Step<Attribute> createAttributeStep(String string, String string2) {
        return Step.createAttributeStep(string, string2, null);
    }

    public static Step<Attribute> createAttributeStep(String string, String string2, IPredicate<Attribute> iPredicate) {
        return new Step<Attribute>(Axis.attribute, string, string2, Attribute.class, iPredicate);
    }

    public static Step<Element> createElementStep(String string, String string2) {
        return Step.createElementStep(string, string2, null);
    }

    public static Step<Element> createElementStep(String string, String string2, IPredicate<Element> iPredicate) {
        return Step.createElementStep(Axis.child, string, string2, iPredicate);
    }

    public static Step<Element> createElementStep(Axis axis, String string) {
        return Step.createElementStep(axis, string, null);
    }

    public static Step<Element> createElementStep(Axis axis, String string, String string2) {
        return Step.createElementStep(axis, string, string2, null);
    }

    public static Step<Element> createElementStep(Axis axis, String string, String string2, IPredicate<Element> iPredicate) {
        return new Step<Element>(axis, string, string2, Element.class, iPredicate);
    }

    private Step(Axis axis, String string, String string2, Class<T> clazz, IPredicate<T> iPredicate) {
        this.axis = axis;
        this.name = string;
        this.ns = string2;
        this.clazz = clazz;
        this.node = SimpleXMLPath.Node.get(this.clazz);
        this.pred = iPredicate;
    }

    public final Axis getAxis() {
        return this.axis;
    }

    public final String getName() {
        return this.name;
    }

    protected final Namespace getNS(Element element) {
        return this.ns == null ? Namespace.NO_NAMESPACE : element.getNamespace(this.ns);
    }

    protected final T evaluate(Object object) {
        if (object == null) {
            return null;
        }
        T t = this.clazz.cast(object);
        T t2 = this.node.filter(t, this.getName(), this.ns);
        if (t2 == null) {
            return null;
        }
        return (T)(this.pred == null || this.pred.evaluateChecked(t2) ? t2 : null);
    }

    protected final void add(Object object, List<T> list) {
        T t = this.evaluate(object);
        if (t != null) {
            list.add(t);
        }
    }

    final <U> List<T> nextNodes(SimpleXMLPath.Node<U> node, U u) {
        return this.nextNodes(new ArrayList(), node, u);
    }

    final <U> List<T> nextNodes(List<T> list, SimpleXMLPath.Node<U> node, U u) {
        node.nextNodes(list, u, this);
        return list;
    }

    final <U> List<T> nextNodes(List<U> list) {
        int n = list.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        SimpleXMLPath.Node<U> node = SimpleXMLPath.Node.get(list.get(0));
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.nextNodes(arrayList, node, list.get(i));
        }
        return arrayList;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + " " + (Object)((Object)this.getAxis()) + " " + this.ns + ":" + this.name;
    }

    public static enum Axis {
        attribute,
        child,
        ancestor,
        descendantOrSelf;

    }
}

