/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.filter.Filter;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.Step;

public final class SimpleXMLPath<T> {
    private final List<Step<?>> items;
    private final Step<T> lastItem;

    public static <T> SimpleXMLPath<T> create(List<Step<?>> list, Step<T> step) {
        SimpleXMLPath<T> simpleXMLPath = new SimpleXMLPath<T>(step);
        for (Step<?> step2 : list) {
            simpleXMLPath.add(step2);
        }
        return simpleXMLPath;
    }

    public static <T> SimpleXMLPath<T> create(Step<T> step) {
        return new SimpleXMLPath<T>(step);
    }

    public static <T> SimpleXMLPath<T> create(Step<?> step, Step<T> step2) {
        SimpleXMLPath<T> simpleXMLPath = new SimpleXMLPath<T>(step2);
        simpleXMLPath.add(step);
        return simpleXMLPath;
    }

    public static <T> SimpleXMLPath<T> create(Step<?> step, Step<?> step2, Step<T> step3) {
        return SimpleXMLPath.create(Arrays.asList(step, step2), step3);
    }

    private SimpleXMLPath(Step<T> step) {
        this.lastItem = step;
        this.items = new ArrayList();
    }

    public final SimpleXMLPath add(String string) {
        return this.add(Step.createElementStep(string, null, null));
    }

    public final SimpleXMLPath add(Step<?> step) {
        this.items.add(step);
        return this;
    }

    public final T selectSingleNode(Object object) {
        return this.selectSingleNode(object, this.items);
    }

    private final T selectSingleNode(Object object, List<Step<?>> list) {
        int n = list.size();
        if (n > 0) {
            Step<?> step = list.get(0);
            List<?> list2 = step.nextNodes(Node.get(object), object);
            List<Step<?>> list3 = list.subList(1, n);
            int n2 = list2.size();
            for (int i = 0; i < n2; ++i) {
                T t = this.selectSingleNode(list2.get(i), list3);
                if (t == null) continue;
                return t;
            }
            return null;
        }
        return CollectionUtils.getFirst(this.lastItem.nextNodes(Node.get(object), object));
    }

    public final List<T> selectNodes(Object object) {
        List<Object> list = Collections.singletonList(object);
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            Step<?> step = this.items.get(i);
            List<?> list2 = step.nextNodes(list);
            if (list2.isEmpty()) {
                return Collections.emptyList();
            }
            list = list2;
        }
        return this.lastItem.nextNodes(list);
    }

    static class ElementNode
    extends Node<Element> {
        ElementNode() {
        }

        @Override
        public <S> void nextNodes(List<S> list, Element element, final Step<S> step) {
            Step.Axis axis = step.getAxis();
            if (axis == Step.Axis.ancestor) {
                step.add(element.getParent(), list);
            } else if (axis == Step.Axis.attribute) {
                List list2 = element.getAttributes();
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    step.add(list2.get(i), list);
                }
            } else if (axis == Step.Axis.child) {
                for (Object e : element.getChildren()) {
                    step.add(e, list);
                }
            } else if (axis == Step.Axis.descendantOrSelf) {
                step.add(element, list);
                Iterator iterator = element.getDescendants(new Filter(){

                    @Override
                    public boolean matches(Object object) {
                        if (!(object instanceof Element)) {
                            return false;
                        }
                        return step.evaluate(object) != null;
                    }
                });
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            } else {
                throw new IllegalArgumentException(this + " cannot take the passed step: " + (Object)((Object)axis));
            }
        }

        @Override
        Element filter(Element element, String string, String string2) {
            if (element == null) {
                return null;
            }
            if (string != null && !string.equals(element.getName())) {
                return null;
            }
            if (string2 != null && !string2.equals(element.getNamespacePrefix())) {
                return null;
            }
            return element;
        }
    }

    static class AttributeNode
    extends Node<Attribute> {
        AttributeNode() {
        }

        @Override
        public <S> void nextNodes(List<S> list, Attribute attribute, Step<S> step) {
            if (step.getAxis() != Step.Axis.ancestor) {
                throw new IllegalArgumentException(this + " cannot take the passed step: " + step);
            }
            step.add(attribute.getParent(), list);
        }

        @Override
        Attribute filter(Attribute attribute, String string, String string2) {
            if (attribute == null) {
                return null;
            }
            if (string != null && !string.equals(attribute.getName())) {
                return null;
            }
            if (string2 != null && !string2.equals(attribute.getNamespacePrefix())) {
                return null;
            }
            return attribute;
        }
    }

    static abstract class Node<T> {
        static final Node<Element> elem = new ElementNode();
        static final Node<Attribute> attr = new AttributeNode();

        Node() {
        }

        public static <TT> Node<TT> get(TT TT) {
            if (TT instanceof Attribute) {
                return attr;
            }
            if (TT instanceof Element) {
                return elem;
            }
            throw new IllegalArgumentException("unknown Node: " + TT);
        }

        public static <TT> Node<TT> get(Class<TT> clazz) {
            if (clazz == Attribute.class) {
                return attr;
            }
            if (clazz == Element.class) {
                return elem;
            }
            throw new IllegalArgumentException("unknown Node: " + clazz);
        }

        public abstract <S> void nextNodes(List<S> var1, T var2, Step<S> var3);

        abstract T filter(T var1, String var2, String var3);

        public final String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

