/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jopendocument.util.Log;
import org.jopendocument.util.RTInterruptedException;
import org.jopendocument.util.StreamUtils;

public abstract class DesktopEnvironment {
    private static DesktopEnvironment DE = null;
    private String version = null;

    public static final boolean test(String ... stringArray) throws RTInterruptedException {
        try {
            return Runtime.getRuntime().exec(stringArray).waitFor() == 0;
        }
        catch (InterruptedException interruptedException) {
            throw new RTInterruptedException(interruptedException);
        }
        catch (IOException iOException) {
            Log.get().finer(iOException.getLocalizedMessage());
            return false;
        }
    }

    public static final String cmdSubstitution(Process process) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(102400);
        StreamUtils.copy(process.getInputStream(), byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    private static final DesktopEnvironment detectDE() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return new Windows();
        }
        if (string.startsWith("Mac OS")) {
            return new Mac();
        }
        if (string.startsWith("Linux")) {
            if ("true".equalsIgnoreCase(System.getenv("KDE_FULL_SESSION"))) {
                return new KDE();
            }
            if (System.getenv("GNOME_DESKTOP_SESSION_ID") != null) {
                return new Gnome();
            }
            if (DesktopEnvironment.test("dbus-send", "--print-reply", "--dest=org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus.GetNameOwner", "string:org.gnome.SessionManager")) {
                return new Gnome();
            }
            try {
                String string2 = DesktopEnvironment.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"xprop", "-root", "_DT_SAVE_MODE"}));
                if (string2.endsWith(" = \"xfce4\"")) {
                    return new XFCE();
                }
            }
            catch (IOException iOException) {
                Log.get().fine(iOException.getLocalizedMessage());
            }
        }
        return new Unknown();
    }

    public static final DesktopEnvironment getDE() {
        if (DE == null) {
            DE = DesktopEnvironment.detectDE();
        }
        return DE;
    }

    public static final void resetDE() {
        DE = null;
    }

    private DesktopEnvironment() {
    }

    protected abstract String findVersion();

    public final String getVersion() {
        if (this.version == null) {
            this.version = this.findVersion();
        }
        return this.version;
    }

    public String toString() {
        return "DesktopEnvironment " + this.getClass().getSimpleName();
    }

    public static void main(String[] stringArray) {
        System.out.println(DesktopEnvironment.getDE() + " version " + DesktopEnvironment.getDE().getVersion());
    }

    public static final class Mac
    extends DEisOS {
    }

    public static final class Windows
    extends DEisOS {
    }

    private static class DEisOS
    extends DesktopEnvironment {
        private DEisOS() {
        }

        @Override
        protected String findVersion() {
            return System.getProperty("os.version");
        }
    }

    public static final class Unknown
    extends DesktopEnvironment {
        @Override
        protected String findVersion() {
            return "";
        }
    }

    public static final class XFCE
    extends DesktopEnvironment {
        @Override
        protected String findVersion() {
            return "";
        }
    }

    public static final class KDE
    extends DesktopEnvironment {
        private static final Pattern versionPattern = Pattern.compile("^KDE: (.*)$", 8);

        @Override
        protected String findVersion() {
            try {
                String string = KDE.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"kde-config", "--version"}));
                Matcher matcher = versionPattern.matcher(string);
                matcher.find();
                return matcher.group(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    public static final class Gnome
    extends DesktopEnvironment {
        @Override
        protected String findVersion() {
            try {
                String string = Gnome.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"gnome-about", "--version"}));
                String[] stringArray = string.split(" ");
                return stringArray[stringArray.length - 1];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

