/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class DecimalUtils {
    public static final MathContext HIGH_PRECISION = new MathContext(MathContext.DECIMAL128.getPrecision(), RoundingMode.HALF_UP);

    public static int intDigits(BigDecimal bigDecimal) {
        return Math.max(1, bigDecimal.precision() - bigDecimal.scale());
    }

    public static int decimalDigits(BigDecimal bigDecimal) {
        return Math.max(0, bigDecimal.stripTrailingZeros().scale());
    }

    public static BigDecimal round(BigDecimal bigDecimal, int n) {
        return DecimalUtils.round(bigDecimal, n, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal bigDecimal, int n, RoundingMode roundingMode) {
        return bigDecimal.round(new MathContext(DecimalUtils.intDigits(bigDecimal) + n, roundingMode));
    }
}

