/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.renderer.ODTCellRenderer;

public class ODTCellBorderRenderer
implements ODTCellRenderer {
    private static final boolean debug = false;

    private static float getWidth(int n, double d) {
        double d2 = (double)n / d;
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        return (float)d2;
    }

    @Override
    public final void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d, TableTableCell tableTableCell, StyleTableCellProperties styleTableCellProperties) {
        if (styleTableCellProperties != null) {
            float f;
            if (styleTableCellProperties.hasLeftBorder()) {
                graphics2D.setColor(styleTableCellProperties.getBorderColorLeft());
                f = ODTCellBorderRenderer.getWidth(styleTableCellProperties.getBorderWidthLeft(), d);
                graphics2D.setStroke(new BasicStroke(f));
                graphics2D.drawLine(n, n2, n, n2 + n4);
            }
            if (styleTableCellProperties.hasRightBorder()) {
                graphics2D.setColor(styleTableCellProperties.getBorderColorRight());
                f = ODTCellBorderRenderer.getWidth(styleTableCellProperties.getBorderWidthRight(), d);
                graphics2D.setStroke(new BasicStroke(f));
                graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
            }
            if (styleTableCellProperties.hasTopBorder()) {
                graphics2D.setColor(styleTableCellProperties.getBorderColorTop());
                f = ODTCellBorderRenderer.getWidth(styleTableCellProperties.getBorderWidthTop(), d);
                graphics2D.setStroke(new BasicStroke(f));
                graphics2D.drawLine(n, n2, n + n3, n2);
            }
            if (styleTableCellProperties.hasBottomBorder()) {
                graphics2D.setColor(styleTableCellProperties.getBorderColorBottom());
                f = ODTCellBorderRenderer.getWidth(styleTableCellProperties.getBorderWidthBottom(), d);
                graphics2D.setStroke(new BasicStroke(f));
                graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
            }
        }
    }
}

