/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.link;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jopendocument.util.DesktopEnvironment;

public class OOInstallation {
    private static OOInstallation instance;
    private static final Pattern stringValuePattern;
    private static final String OOBundleID = "org.openoffice.script";
    private final File executable;
    private final List<File> classpath;

    public static OOInstallation getInstance() throws IOException {
        if (instance == null) {
            instance = OOInstallation.detectInstall();
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    private static String cmdSubstitution(String ... stringArray) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.redirectErrorStream(false);
        return DesktopEnvironment.cmdSubstitution(processBuilder.start());
    }

    static final URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Couldn't transform to URL " + file, malformedURLException);
        }
    }

    private static String findRootPath() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"HKEY_LOCAL_MACHINE\\SOFTWARE\\OpenOffice.org", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\OpenOffice.org"}) {
            if (!DesktopEnvironment.test("reg", "query", string)) continue;
            return string;
        }
        return null;
    }

    private static Map<String, String> getStringValues(String string, String string2) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = DesktopEnvironment.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"reg", "query", string, string2}));
        Matcher matcher = stringValuePattern.matcher(string3);
        while (matcher.find()) {
            hashMap.put(matcher.group(1), matcher.group(2));
        }
        return hashMap;
    }

    private static final void addPaths(List<File> list, File file, String string, String string2) throws IOException {
        OOInstallation.add(list, new File(file, "classes"));
        if (string2 != null) {
            OOInstallation.add(list, string2 + File.separator + "java");
            OOInstallation.add(list, string2 + File.separator + "share" + File.separator + "java");
        }
        if (string != null) {
            OOInstallation.add(list, string + File.separator + "program" + File.separator + "classes");
        }
    }

    private static final void addUnixPaths(List<File> list, File file) throws IOException {
        File file2 = file.getParentFile();
        String string = file2.getPath() + File.separator + "basis-link";
        String string2 = string + File.separator + "ure-link";
        OOInstallation.addPaths(list, file, string, string2);
    }

    private static void add(List<File> list, File file) {
        if (file != null && file.isDirectory()) {
            list.add(file);
        }
    }

    private static void add(List<File> list, String string) {
        if (string != null) {
            OOInstallation.add(list, new File(string));
        }
    }

    private static OOInstallation detectInstall() throws IOException {
        File file;
        ArrayList<File> arrayList = new ArrayList<File>(3);
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            String string2 = OOInstallation.findRootPath();
            if (string2 == null) {
                return null;
            }
            Map<String, String> map = OOInstallation.getStringValues(string2 + "\\UNO\\InstallPath", "/ve");
            if (map.size() != 1) {
                throw new IOException("No UNO install path: " + map);
            }
            File file2 = new File(map.values().iterator().next());
            if (!file2.isDirectory()) {
                throw new IOException(file2 + " is not a directory");
            }
            file = new File(file2, "soffice.exe");
            Map<String, String> map2 = OOInstallation.getStringValues(string2 + "\\Layers\\OpenOffice.org", "/s");
            OOInstallation.addPaths(arrayList, file2, map2.get("BASISINSTALLLOCATION"), map2.get("UREINSTALLLOCATION"));
        } else if (string.startsWith("Mac OS")) {
            String string3 = OOInstallation.cmdSubstitution("osascript", "-e", "tell application id \"com.apple.Finder\" to URL of application file id \"org.openoffice.script\"").trim();
            if (string3.length() == 0) {
                return null;
            }
            try {
                File file3 = new File(new URI(string3).getPath());
                file = new File(file3, "Contents/MacOS/soffice");
                OOInstallation.addUnixPaths(arrayList, new File(file3, "Contents/program"));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
        } else if (string.startsWith("Linux")) {
            String string4 = OOInstallation.cmdSubstitution("which", "soffice").trim();
            if (string4.length() != 0) {
                file = new File(string4).getCanonicalFile();
            } else {
                File file4 = new File("/usr/lib/openoffice/program/soffice");
                File file5 = file = file4.canExecute() ? file4 : null;
            }
            if (file != null) {
                OOInstallation.addUnixPaths(arrayList, file.getParentFile());
            }
        } else {
            file = null;
        }
        return file == null ? null : new OOInstallation(file, arrayList);
    }

    private OOInstallation(File file, List<File> list) throws IOException {
        if (!file.isFile()) {
            throw new IOException("executable not found at " + file);
        }
        this.executable = file;
        this.classpath = Collections.unmodifiableList(new ArrayList<File>(list));
    }

    public final File getExecutable() {
        return this.executable;
    }

    public final List<File> getClasspath() {
        return this.classpath;
    }

    public final List<URL> getURLs(final Set<String> set) {
        int n = this.getClasspath().size();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < n; ++i) {
            File[] fileArray;
            for (File file : fileArray = this.getClasspath().get(i).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return set.contains(file.getName());
                }
            })) {
                arrayList.add(OOInstallation.toURL(file));
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " exe: " + this.getExecutable() + " classpath: " + this.getClasspath();
    }

    public static void main(String[] stringArray) {
        try {
            OOInstallation oOInstallation = OOInstallation.getInstance();
            System.out.println(oOInstallation == null ? "Not installed" : oOInstallation);
        }
        catch (IOException iOException) {
            System.out.println("Couldn't detect OpenOffice.org: " + iOException.getLocalizedMessage());
            iOException.printStackTrace();
        }
    }

    static {
        stringValuePattern = Pattern.compile("^\\s*(.+?)\\s+REG_SZ\\s+(.+?)$", 8);
    }
}

