/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.io;

import java.util.List;
import java.util.Stack;
import org.jopendocument.io.FontFaceDecls;
import org.jopendocument.io.StyleTableProperties;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.number.NumberNumberStyle;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeScripts;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.style.StyleFontFace;
import org.jopendocument.model.style.StyleParagraphProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.style.StyleTableColumnProperties;
import org.jopendocument.model.style.StyleTableRowProperties;
import org.jopendocument.model.style.StyleTextProperties;
import org.jopendocument.model.table.TableShapes;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableHeaderColumns;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.text.TextP;
import org.jopendocument.model.text.TextSpan;
import org.jopendocument.util.ValueHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxContentUnmarshaller
extends DefaultHandler {
    private OfficeAutomaticStyles autostyles;
    private OfficeBody body;
    private Object current;
    private final OpenDocument document;
    private FontFaceDecls fontDeclarations;
    private OfficeScripts scripts;
    private final Stack<Object> stack;

    public SaxContentUnmarshaller(OpenDocument openDocument) {
        this.document = openDocument;
        this.stack = new Stack();
    }

    private void assertParsed(Attributes attributes, int n) {
        if (attributes.getLength() > n) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                System.err.println(attributes.getQName(i) + "  -> " + attributes.getValue(i));
            }
            throw new IllegalStateException("Somme attributes are not parsed");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n, n2);
        if (this.current instanceof TextP) {
            ((TextP)this.current).addToLastTextSpan(stringBuffer.toString());
        } else if (this.current instanceof TextSpan) {
            ((TextSpan)this.current).concantValue(stringBuffer.toString());
        }
    }

    private static void dumpAttributes(Attributes attributes) {
        System.err.println("Dump attributes:");
        for (int i = 0; i < attributes.getLength(); ++i) {
            System.err.println("'" + attributes.getQName(i) + "'  -> '" + attributes.getValue(i) + "'");
        }
    }

    public void dumpAutoStyles() {
        List<StyleStyle> list = this.autostyles.getStyles();
        for (StyleStyle styleStyle : list) {
            System.out.println(styleStyle);
        }
    }

    public void dumpSpreadSheets() {
        List<OfficeSpreadsheet> list = this.body.getOfficeSpreadsheets();
        for (OfficeSpreadsheet officeSpreadsheet : list) {
            System.out.println(officeSpreadsheet);
            List<TableTable> list2 = officeSpreadsheet.getTables();
            for (TableTable tableTable : list2) {
                this.dumpRows(tableTable);
                List<TableTableColumn> list3 = tableTable.getColumnsInRange(tableTable.getPrintStartCol(), tableTable.getPrintStopCol());
                for (TableTableColumn tableTableColumn : list3) {
                    System.out.println(tableTableColumn.getWidth());
                }
            }
        }
    }

    private void dumpRows(TableTable tableTable) {
        for (TableTableRow tableTableRow : tableTable.getRows()) {
            TableTableCell[] tableTableCellArray;
            for (TableTableCell tableTableCell : tableTableCellArray = tableTableRow.getCellsInRange(tableTable.getPrintStartCol(), tableTable.getPrintStopCol())) {
                if (tableTableCell.getTextP() == null) continue;
                TextP textP = tableTableCell.getTextP();
                List<TextSpan> list = textP.getTextSpans();
                System.out.println("TextP:" + list);
            }
        }
    }

    public void dumpSpreadSheetsRows() {
        List<OfficeSpreadsheet> list = this.body.getOfficeSpreadsheets();
        for (OfficeSpreadsheet officeSpreadsheet : list) {
            System.out.println(officeSpreadsheet);
            List<TableTable> list2 = officeSpreadsheet.getTables();
            for (TableTable tableTable : list2) {
                System.out.println("Table ===================");
                for (TableTableRow tableTableRow : tableTable.getRows()) {
                    System.out.println(tableTableRow.getText() + " repeated:" + tableTableRow.getTableNumberRowsRepeated());
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.current instanceof TableTable) {
            ((TableTable)this.current).completed();
        }
        this.pop();
    }

    public OfficeAutomaticStyles getAutomaticstyles() {
        return this.autostyles;
    }

    public OfficeBody getBody() {
        return this.body;
    }

    private void pop() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.peek();
        }
    }

    private void push(Object object) {
        this.stack.push(object);
        this.current = object;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("office:automatic-styles")) {
            this.autostyles = new OfficeAutomaticStyles();
            this.document.setAutomaticStyles(this.autostyles);
            this.push(this.autostyles);
        } else if (string3.equals("style:style")) {
            StyleStyle styleStyle = new StyleStyle();
            styleStyle.setStyleName(attributes.getValue("style:name"));
            styleStyle.setStyleFamily(attributes.getValue("style:family"));
            styleStyle.setStyleParentStyleName(attributes.getValue("style:parent-style-name"));
            styleStyle.setMasterPageName(attributes.getValue("style:master-page-name"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autostyles.addStyle(styleStyle);
            } else {
                System.err.println("Not OfficeAutomaticStyles:" + this.current);
                Thread.dumpStack();
                this.dumpStack();
            }
            this.push(styleStyle);
        } else if (string3.equals("number:number-style")) {
            NumberNumberStyle numberNumberStyle = new NumberNumberStyle();
            numberNumberStyle.setStyleName(attributes.getValue("style:name"));
            numberNumberStyle.setStyleFamily(attributes.getValue("style:family"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autostyles.addStyle(numberNumberStyle);
            } else {
                System.err.println("Not OfficeAutomaticStyles:" + this.current);
                Thread.dumpStack();
            }
            this.push(numberNumberStyle);
        } else if (string3.equals("style:table-row-properties")) {
            StyleTableRowProperties styleTableRowProperties = new StyleTableRowProperties();
            styleTableRowProperties.setFoBreakBefore(attributes.getValue("fo:break-before"));
            styleTableRowProperties.setRowHeight(attributes.getValue("style:row-height"));
            styleTableRowProperties.setUseOptimalRowHeight(attributes.getValue("style:use-optimal-row-height"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableRowProperties(styleTableRowProperties);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleTableRowProperties);
        } else if (string3.equals("style:table-properties")) {
            StyleTableProperties styleTableProperties = new StyleTableProperties();
            styleTableProperties.setDisplay(ValueHelper.getBoolean(attributes.getValue("table:display")));
            styleTableProperties.setWritingMode(attributes.getValue("style:writing-mode"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableProperties(styleTableProperties);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleTableProperties);
        } else if (string3.equals("style:table-cell-properties")) {
            StyleTableCellProperties styleTableCellProperties = new StyleTableCellProperties();
            styleTableCellProperties.setVerticalAlign(attributes.getValue("style:vertical-align"));
            styleTableCellProperties.setBackgroundColor(attributes.getValue("fo:background-color"));
            styleTableCellProperties.setPadding(attributes.getValue("fo:padding"));
            styleTableCellProperties.setTextAlignSource(attributes.getValue("style:text-align-source"));
            styleTableCellProperties.setRepeatContent(attributes.getValue("style:repeat-content"));
            styleTableCellProperties.setBorderLeft(attributes.getValue("fo:border-left"));
            styleTableCellProperties.setBorderRight(attributes.getValue("fo:border-right"));
            styleTableCellProperties.setBorderTop(attributes.getValue("fo:border-top"));
            styleTableCellProperties.setBorderBottom(attributes.getValue("fo:border-bottom"));
            styleTableCellProperties.setBorder(attributes.getValue("fo:border"));
            styleTableCellProperties.setWrapOption(attributes.getValue("fo:wrap-option"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableCellProperties(styleTableCellProperties);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleTableCellProperties);
        } else if (string3.equals("style:text-properties")) {
            StyleTextProperties styleTextProperties = new StyleTextProperties();
            styleTextProperties.setFontName(attributes.getValue("style:font-name"));
            styleTextProperties.setFontSize(attributes.getValue("fo:font-size"));
            styleTextProperties.setFontWeight(attributes.getValue("fo:font-weight"));
            styleTextProperties.setColor(attributes.getValue("fo:color"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTextProperties(styleTextProperties);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleTextProperties);
        } else if (string3.equals("style:table-column-properties")) {
            StyleTableColumnProperties styleTableColumnProperties = new StyleTableColumnProperties();
            styleTableColumnProperties.setFoBreakBefore(attributes.getValue("fo:break-before"));
            styleTableColumnProperties.setStyleColumnWidth(attributes.getValue("style:column-width"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableColumnProperties(styleTableColumnProperties);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleTableColumnProperties);
        } else if (string3.equals("style:paragraph-properties")) {
            StyleParagraphProperties styleParagraphProperties = new StyleParagraphProperties();
            styleParagraphProperties.setTextAlign(attributes.getValue("fo:text-align"));
            styleParagraphProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setParagraphProperties(styleParagraphProperties);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleParagraphProperties);
        } else if (string3.equals("office:body")) {
            this.body = new OfficeBody();
            this.push(this.body);
        } else if (string3.equals("office:spreadsheet")) {
            OfficeSpreadsheet officeSpreadsheet = new OfficeSpreadsheet();
            if (this.current instanceof OfficeBody) {
                ((OfficeBody)this.current).addOfficeSpreadsheet(officeSpreadsheet);
            } else {
                System.err.println("Not StyleStyle:" + this.current);
                Thread.dumpStack();
            }
            this.push(officeSpreadsheet);
        } else if (string3.equals("table:table")) {
            TableTable tableTable = new TableTable();
            SaxContentUnmarshaller.dumpAttributes(attributes);
            tableTable.setTableName(attributes.getValue("table:name"));
            tableTable.setTableStyleName(attributes.getValue("table:style-name"));
            String string4 = attributes.getValue("table:print-ranges");
            if (string4 != null) {
                tableTable.setTablePrintRanges(string4);
            }
            this.assertParsed(attributes, 3);
            if (this.current instanceof OfficeSpreadsheet) {
                ((OfficeSpreadsheet)this.current).addTable(tableTable);
            } else {
                System.err.println("Not OfficeSpreadsheet:" + this.current);
                Thread.dumpStack();
            }
            this.push(tableTable);
        } else if (string3.equals("table:table-column")) {
            TableTableColumn tableTableColumn = new TableTableColumn();
            tableTableColumn.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableColumn.setTableDefaultCellStyleName(attributes.getValue("table:default-cell-style-name"));
            tableTableColumn.setTableNumberColumnsRepeated(attributes.getValue("table:number-columns-repeated"));
            this.assertParsed(attributes, 3);
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).addColumn(tableTableColumn);
            } else if (this.current instanceof TableTableHeaderColumns) {
                ((TableTable)this.stack.get(this.stack.size() - 2)).addColumn(tableTableColumn);
            } else {
                System.err.println("Not TableTable:" + this.current + " class:" + this.current.getClass().getName());
                this.dumpStack();
            }
            this.push(tableTableColumn);
        } else if (string3.equals("table:table-row")) {
            TableTableRow tableTableRow = new TableTableRow();
            tableTableRow.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableRow.setTableNumberRowsRepeated(attributes.getValue("table:number-rows-repeated"));
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).addRow(tableTableRow);
            } else {
                System.err.println("Not TableTable:" + this.current);
                this.dumpStack();
            }
            this.push(tableTableRow);
        } else if (string3.equals("table:table-cell") || string3.equals("table:covered-table-cell")) {
            TableTableCell tableTableCell = new TableTableCell();
            tableTableCell.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableCell.setTableNumberColumnsRepeated(attributes.getValue("table:number-columns-repeated"));
            tableTableCell.setTableNumberColumnsSpanned(attributes.getValue("table:number-columns-spanned"));
            tableTableCell.setTableNumberRowsSpanned(attributes.getValue("table:number-rows-spanned"));
            tableTableCell.setTableValueType(attributes.getValue("office:value-type"));
            if (string3.equals("table:covered-table-cell")) {
                tableTableCell.setCovered(true);
            }
            if (this.current instanceof TableTableRow) {
                ((TableTableRow)this.current).addCell(tableTableCell);
            } else {
                System.err.println("Not TableTableRow:" + this.current);
                Thread.dumpStack();
            }
            this.push(tableTableCell);
        } else if (string3.equals("text:p")) {
            TextP textP = new TextP();
            if (this.current instanceof TableTableCell) {
                ((TableTableCell)this.current).setTextP(textP);
            } else if (this.current instanceof DrawImage) {
                ((DrawImage)this.current).setTextP(textP);
            } else {
                System.err.println("Not TableTableCell:" + this.current + " classe:" + this.current.getClass());
                Thread.dumpStack();
            }
            this.push(textP);
        } else if (string3.equals("text:span")) {
            TextSpan textSpan = new TextSpan();
            textSpan.setTextStyle(this.autostyles.getTextStyle(attributes.getValue("text:style-name")));
            if (this.current instanceof TextP) {
                ((TextP)this.current).addTextSpan(textSpan);
            } else {
                System.err.println("Not TextP:" + this.current);
                Thread.dumpStack();
            }
            this.push(textSpan);
        } else if (string3.equals("draw:frame")) {
            DrawFrame drawFrame = new DrawFrame();
            drawFrame.setSvgWidth(attributes.getValue("svg:width"));
            drawFrame.setSvgHeight(attributes.getValue("svg:height"));
            drawFrame.setSvgX(attributes.getValue("svg:x"));
            drawFrame.setSvgY(attributes.getValue("svg:y"));
            if (this.current instanceof TableTableCell) {
                ((TableTableCell)this.current).addDrawFrame(drawFrame);
            } else if (this.current instanceof TableShapes) {
                ((TableShapes)this.current).addDrawFrame(drawFrame);
            } else {
                System.err.println("Not TableTableCell:" + this.current);
                Thread.dumpStack();
            }
            this.push(drawFrame);
        } else if (string3.equals("draw:image")) {
            DrawImage drawImage = new DrawImage();
            String string5 = attributes.getValue("xlink:href");
            drawImage.setXlinkHref(string5);
            this.document.preloadImage(string5);
            if (this.current instanceof DrawFrame) {
                ((DrawFrame)this.current).setDrawImage(drawImage);
            } else {
                System.err.println("Not DrawFrame:" + this.current);
                Thread.dumpStack();
            }
            this.push(drawImage);
        } else if (string3.equals("table:shapes")) {
            TableShapes tableShapes = new TableShapes();
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).setTableShapes(tableShapes);
            } else {
                System.err.println("Not TableTable:" + this.current);
                Thread.dumpStack();
            }
            this.push(tableShapes);
        } else if (string3.equals("office:scripts")) {
            this.scripts = new OfficeScripts();
            this.push(this.scripts);
        } else if (string3.equals("table:table-header-columns")) {
            TableTableHeaderColumns tableTableHeaderColumns = new TableTableHeaderColumns();
            this.push(tableTableHeaderColumns);
        } else if (string3.equals("office:font-face-decls")) {
            this.fontDeclarations = new FontFaceDecls();
            this.push(this.fontDeclarations);
        } else if (string3.equals("style:font-face")) {
            StyleFontFace styleFontFace = new StyleFontFace();
            styleFontFace.setStyleName(attributes.getValue("style:name"));
            styleFontFace.setFontFamily(attributes.getValue("svg:font-family"));
            styleFontFace.setFontFamilyGeneric(attributes.getValue("style:font-family-generic"));
            styleFontFace.setFontPitch(attributes.getValue("style:font-pitch"));
            if (this.current instanceof FontFaceDecls) {
                ((FontFaceDecls)this.current).addFontFace(styleFontFace);
            } else {
                System.err.println("Not FontFaceDecls:" + this.current);
                Thread.dumpStack();
            }
            this.push(styleFontFace);
        } else {
            System.err.println("content.xml : ignoring :" + string3);
            this.push(string3);
        }
    }

    private void dumpStack() {
        System.err.println("Stack:");
        for (int i = 0; i < this.stack.size(); ++i) {
            System.err.println("Item " + i + " : " + this.stack.get(i).getClass().getCanonicalName() + " : " + this.stack.get(i));
        }
        System.err.flush();
        System.exit(0);
    }
}

