/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.JDOMException;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.template.Template;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;

public class EngineTemplate {
    private final Template template;
    private final DataModel engine;

    public EngineTemplate(File file, DataModel dataModel) throws IOException, TemplateException, JDOMException {
        this.template = new Template(file);
        this.engine = dataModel;
    }

    public EngineTemplate(InputStream inputStream, DataModel dataModel) throws IOException, TemplateException, JDOMException {
        this.template = new Template(inputStream);
        this.engine = dataModel;
    }

    public final void showParagraph(String string) {
        this.setField("showParagraph_" + string, Boolean.TRUE);
    }

    public final void hideParagraph(String string) {
        this.setField("showParagraph_" + string, Boolean.FALSE);
    }

    public final void showTable(String string) {
        this.setField("showTable_" + string, Boolean.TRUE);
    }

    public final void hideTable(String string) {
        this.setField("showTable_" + string, Boolean.FALSE);
    }

    public final void showTableRow(String string) {
        this.setField("showTableRow_" + string, Boolean.TRUE);
    }

    public final void hideTableRow(String string) {
        this.setField("showTableRow_" + string, Boolean.FALSE);
    }

    public final void showSection(String string) {
        this.setField("showSection_" + string, Boolean.TRUE);
    }

    public final void hideSection(String string) {
        this.setField("showSection_" + string, Boolean.FALSE);
    }

    public final void showListItem(String string) {
        this.setField("showListItem_" + string, Boolean.TRUE);
    }

    public final void hideListItem(String string) {
        this.setField("showListItem_" + string, Boolean.FALSE);
    }

    public void setField(String string, Object object) {
        this.engine.put(string, object);
    }

    public ODSingleXMLDocument createDocument() throws TemplateException {
        return this.template.createDocument(this.engine);
    }

    public File saveAs(File file) throws IOException, TemplateException {
        ODSingleXMLDocument oDSingleXMLDocument = this.createDocument();
        return oDSingleXMLDocument.saveAs(file);
    }
}

