/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.dom.spreadsheet.TableStyle;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.Tuple2;

public class Table<D extends ODDocument>
extends TableCalcNode<TableStyle, D> {
    private final List<Row<D>> rows = new ArrayList<Row<D>>();
    private int headerRowCount;
    private final List<Column<D>> cols = new ArrayList<Column<D>>();
    private int headerColumnCount;

    static Element createEmpty(XMLVersion xMLVersion) {
        Element element = Column.createEmpty(xMLVersion, null);
        Element element2 = Row.createEmpty(xMLVersion).addContent(Cell.createEmpty(xMLVersion));
        return new Element("table", xMLVersion.getTABLE()).addContent(element).addContent(element2);
    }

    static final String getName(Element element) {
        return element.getAttributeValue("name", element.getNamespace("table"));
    }

    public Table(D d, Element element) {
        super(d, element, TableStyle.class);
        this.readColumns();
        this.readRows();
    }

    private void readColumns() {
        this.read(true);
    }

    private final void readRows() {
        this.read(false);
    }

    private final void read(boolean bl) {
        Tuple2<List<Element>, Integer> tuple2 = this.flatten(bl);
        (bl ? this.cols : this.rows).clear();
        for (Element element : tuple2.get0()) {
            if (bl) {
                this.addCol(element);
                continue;
            }
            this.addRow(element);
        }
        if (bl) {
            this.headerColumnCount = tuple2.get1();
        } else {
            this.headerRowCount = tuple2.get1();
        }
    }

    private final void addCol(Element element) {
        this.cols.add(new Column(this, element));
    }

    private Tuple2<List<Element>, Integer> flatten(boolean bl) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this.getElement().getChild("table-header-" + this.getName(bl) + "s", this.getTABLE());
        if (element != null) {
            arrayList.addAll(this.flatten(element, bl));
        }
        int n = arrayList.size();
        arrayList.addAll(this.flatten(this.getElement(), bl));
        return Tuple2.create(arrayList, n);
    }

    private List<Element> flatten(Element element, boolean bl) {
        String string = this.getName(bl);
        List list = element.getChildren("table-" + string, this.getTABLE());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            Attribute attribute = element2.getAttribute("number-" + string + "s-repeated", this.getTABLE());
            if (attribute == null) continue;
            element2.removeAttribute(attribute);
            int n = listIterator.previousIndex();
            int n2 = Integer.parseInt(attribute.getValue());
            if (n2 > 60000) {
                n2 = 10;
            }
            for (int i = 0; i < n2 - 1; ++i) {
                Element element3 = (Element)element2.clone();
                list.add(n, element3);
            }
            listIterator = list.listIterator(n + n2);
        }
        return list;
    }

    public final String getName() {
        return Table.getName(this.getElement());
    }

    public final void setName(String string) {
        this.getElement().setAttribute("name", string, this.getODDocument().getVersion().getTABLE());
    }

    public void detach() {
        this.getElement().detach();
    }

    private final String getName(boolean bl) {
        return bl ? "column" : "row";
    }

    public final Object getPrintRanges() {
        return this.getElement().getAttributeValue("print-ranges", this.getTABLE());
    }

    public final void setPrintRanges(String string) {
        this.getElement().setAttribute("print-ranges", string, this.getTABLE());
    }

    public final void removePrintRanges() {
        this.getElement().removeAttribute("print-ranges", this.getTABLE());
    }

    public final synchronized void duplicateFirstRows(int n, int n2) {
        this.duplicateRows(0, n, n2);
    }

    public final synchronized void insertDuplicatedRows(int n, int n2) {
        this.duplicateRows(n, 1, n2);
    }

    public final synchronized void duplicateRows(int n, int n2, int n3) {
        int n4 = n + n2;
        ArrayList<Element> arrayList = new ArrayList<Element>(n2 * n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = n; j < n4; ++j) {
                Element element = this.rows.get(j).getElement();
                arrayList.add((Element)element.clone());
            }
        }
        JDOMUtils.insertAfter(this.rows.get(n4 - 1).getElement(), arrayList);
        this.readRows();
    }

    private synchronized void addRow(Element element) {
        this.rows.add(new Row(this, element, this.rows.size()));
    }

    public final Point resolveHint(String string) {
        Point point = Table.resolve(string);
        if (point != null) {
            return point;
        }
        throw new IllegalArgumentException(string + " is not a cell ref, if it's a named range, you must use it on a SpreadSheet.");
    }

    public final boolean isCellValid(int n, int n2) {
        if (n > this.getColumnCount()) {
            return false;
        }
        if (n2 > this.getRowCount()) {
            return false;
        }
        return this.getImmutableCellAt(n, n2).isValid();
    }

    public final MutableCell<D> getCellAt(int n, int n2) {
        return this.getRow(n2).getMutableCellAt(n);
    }

    public final MutableCell<D> getCellAt(String string) {
        return this.getCellAt(this.resolveHint(string));
    }

    final MutableCell<D> getCellAt(Point point) {
        return this.getCellAt(point.x, point.y);
    }

    public final void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            object = "";
        }
        if (!object.equals(this.getValueAt(n, n2))) {
            this.getCellAt(n, n2).setValue(object);
        }
    }

    protected final Cell<D> getImmutableCellAt(int n, int n2) {
        return this.getRow(n2).getCellAt(n);
    }

    protected final Cell<D> getImmutableCellAt(String string) {
        Point point = this.resolveHint(string);
        return this.getImmutableCellAt(point.x, point.y);
    }

    public final Object getValueAt(int n, int n2) {
        return this.getImmutableCellAt(n, n2).getValue();
    }

    public final String getStyleNameAt(int n, int n2) {
        String string = this.getImmutableCellAt(n, n2).getStyleAttr();
        if (string != null) {
            return string;
        }
        string = this.getRow(n2).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
        if (string != null) {
            return string;
        }
        return this.getColumn(n).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
    }

    public final CellStyle getStyleAt(int n, int n2) {
        return (CellStyle)CellStyle.DESC.findStyle(this.getODDocument().getPackage(), this.getElement().getDocument(), this.getStyleNameAt(n, n2));
    }

    public final List<Tuple2<Integer, Integer>> getStyleReferences(String string) {
        int n;
        ArrayList<Tuple2<Integer, Integer>> arrayList = new ArrayList<Tuple2<Integer, Integer>>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = this.getColumnCount();
        for (n = 0; n < n2; ++n) {
            if (!string.equals(this.getColumn(n).getElement().getAttributeValue("default-cell-style-name", this.getTABLE()))) continue;
            hashSet.add(n);
        }
        n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            Row<D> row = this.getRow(i);
            String string2 = row.getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
            for (int j = 0; j < n2; ++j) {
                String string3 = row.getCellAt(j).getStyleAttr();
                boolean bl = string3 != null ? string.equals(string3) : (string2 != null ? string.equals(string2) : hashSet.contains(j));
                if (!bl) continue;
                arrayList.add(Tuple2.create(j, i));
            }
        }
        return arrayList;
    }

    public final Object getValueAt(String string) {
        return this.getImmutableCellAt(string).getValue();
    }

    private Row<D> getRow(int n) {
        return this.rows.get(n);
    }

    public final Column<D> getColumn(int n) {
        return this.cols.get(n);
    }

    public final int getRowCount() {
        return this.rows.size();
    }

    public final int getHeaderRowCount() {
        return this.headerRowCount;
    }

    public final int getColumnCount() {
        return this.cols.size();
    }

    public final int getHeaderColumnCount() {
        return this.headerColumnCount;
    }

    public final void setColumnCount(int n) {
        this.setColumnCount(n, -1, false);
    }

    public final void ensureColumnCount(int n) {
        if (n > this.getColumnCount()) {
            this.setColumnCount(n);
        }
    }

    public final void setColumnCount(int n, int n2, boolean bl) {
        int n3 = n - this.getColumnCount();
        if (n3 < 0) {
            this.removeColumn(n, this.getColumnCount(), bl);
        } else if (n3 > 0) {
            int n4 = this.getColumnCount() == 0 ? this.getElement().getContentSize() - 1 : this.getElement().getContent().indexOf(this.getColumn(this.getColumnCount() - 1).getElement());
            Element element = n2 < 0 ? Column.createEmpty(this.getODDocument().getVersion(), this.createDefaultColStyle()) : this.getColumn(n2).getElement();
            for (int i = 0; i < n3; ++i) {
                Element object = (Element)element.clone();
                this.getElement().addContent(n4 + 1 + i, object);
                this.cols.add(new Column(this, object));
            }
            this.updateWidth(bl);
            for (Row<D> row : this.rows) {
                row.columnCountChanged();
            }
        }
    }

    public final void removeColumn(int n, boolean bl) {
        this.removeColumn(n, n + 1, bl);
    }

    public final void removeColumn(int n, int n2, boolean bl) {
        for (Row<D> row : this.rows) {
            row.checkRemove(n, n2);
        }
        this.remove(true, n, n2 - 1);
        this.updateWidth(bl);
        for (Row<D> row : this.rows) {
            row.removeCells(n, n2);
        }
    }

    private void updateWidth(boolean bl) {
        Float f = this.getWidth();
        float f2 = 0.0f;
        Column<D> column = null;
        for (Column<D> object2 : this.cols) {
            Float f3 = object2.getWidth();
            if (f3 != null) {
                assert (f3.floatValue() >= 0.0f);
                f2 += f3.floatValue();
                continue;
            }
            f2 = -1.0f;
            column = object2;
            break;
        }
        if (bl && f != null) {
            if (column != null) {
                throw new IllegalStateException("Cannot keep width since a column has no width : " + column);
            }
            float f3 = f.floatValue() / f2;
            HashSet hashSet = new HashSet();
            for (Column<D> column2 : this.cols) {
                hashSet.add(column2.getStyle());
            }
            for (ColumnStyle columnStyle : hashSet) {
                columnStyle.setWidth(columnStyle.getWidth().floatValue() * f3);
            }
        } else {
            TableStyle tableStyle = (TableStyle)this.getStyle();
            if (tableStyle != null) {
                if (column != null) {
                    throw new IllegalStateException("Cannot update table width since a column has no width : " + column);
                }
                tableStyle.setWidth(f2);
            }
            for (Column<D> column3 : this.cols) {
                ColumnStyle columnStyle = (ColumnStyle)column3.getStyle();
                if (columnStyle == null) continue;
                columnStyle.rmRelWidth();
            }
        }
    }

    public final Float getWidth() {
        TableStyle tableStyle = (TableStyle)this.getStyle();
        return tableStyle == null ? null : tableStyle.getWidth();
    }

    private final ColumnStyle createDefaultColStyle() {
        ColumnStyle columnStyle = (ColumnStyle)ColumnStyle.DESC.createAutoStyle(this.getODDocument().getPackage(), "defaultCol");
        columnStyle.setWidth(20.0f);
        return columnStyle;
    }

    private final void setCount(boolean bl, int n) {
        this.remove(bl, n, -1);
    }

    private final void remove(boolean bl, int n, int n2) {
        int n3;
        List<TableCalcNode> list = bl ? this.cols : this.rows;
        for (int i = n3 = CollectionUtils.getValidIndex(list, n2); i >= n; --i) {
            list.remove(i).getElement().detach();
        }
    }

    public final void ensureRowCount(int n) {
        if (n > this.getRowCount()) {
            this.setRowCount(n);
        }
    }

    public final void setRowCount(int n) {
        this.setRowCount(n, -1);
    }

    public final void setRowCount(int n, int n2) {
        Element element;
        if (n2 < 0) {
            element = Row.createEmpty(this.getODDocument().getVersion());
            element.addContent(Cell.createEmpty(this.getODDocument().getVersion(), this.getColumnCount()));
        } else {
            element = this.getRow(n2).getElement();
        }
        int n3 = n - this.getRowCount();
        if (n3 < 0) {
            this.setCount(false, n);
        } else {
            for (int i = 0; i < n3; ++i) {
                Element element2 = (Element)element.clone();
                this.getElement().addContent(element2);
                this.addRow(element2);
            }
        }
    }

    public final SheetTableModel<D> getTableModel(int n, int n2) {
        return new SheetTableModel(this, n2, n);
    }

    public final SheetTableModel<D> getTableModel(int n, int n2, int n3, int n4) {
        return new SheetTableModel(this, n2, n, n4, n3);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(int n, int n2) {
        return new SheetTableModel.MutableTableModel(this, n2, n);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(Point point, Point point2) {
        return new SheetTableModel.MutableTableModel(this, point.y, point.x, point2.y + 1, point2.x + 1);
    }

    public final void merge(TableModel tableModel, int n, int n2) {
        this.merge(tableModel, n, n2, false);
    }

    public final void merge(TableModel tableModel, int n, int n2, boolean bl) {
        int n3;
        int n4 = bl ? 1 : 0;
        this.ensureColumnCount(n + tableModel.getColumnCount());
        this.ensureRowCount(n2 + tableModel.getRowCount() + n4);
        SheetTableModel.MutableTableModel<D> mutableTableModel = this.getMutableTableModel(n, n2);
        if (bl) {
            for (n3 = 0; n3 < tableModel.getColumnCount(); ++n3) {
                mutableTableModel.setValueAt(tableModel.getColumnName(n3), 0, n3);
            }
        }
        for (n3 = 0; n3 < tableModel.getRowCount(); ++n3) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = tableModel.getValueAt(n3, i);
                mutableTableModel.setValueAt(object, n3 + n4, i);
            }
        }
    }

    static final Point resolve(String string) {
        Matcher matcher = SpreadSheet.minCellPattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return Table.resolve(matcher.group(1), matcher.group(2));
    }

    static final Point resolve(String string, String string2) {
        return new Point(Table.toInt(string), Integer.parseInt(string2) - 1);
    }

    static final int toInt(String string) {
        if (string.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        string = string.toUpperCase();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = n * 26 + (string.charAt(i) - 65 + 1);
        }
        return n - 1;
    }

    static final String toStr(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative column : " + n);
        }
        ++n;
        StringBuilder stringBuilder = new StringBuilder(4);
        while (n > 0) {
            stringBuilder.append((char)(65 + (n - 1) % 26));
            n /= 26;
        }
        return stringBuilder.reverse().toString();
    }

    static final String getAddress(Point point) {
        if (point.x < 0 || point.y < 0) {
            throw new IllegalArgumentException("negative coordinates : " + point);
        }
        return Table.toStr(point.x) + (point.y + 1);
    }
}

