/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.Range;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.Table;

public class SpreadSheet
implements ODDocument {
    private final ODPackage originalFile;
    private final Map<Element, Sheet> sheets;
    private static final String minCell = "\\$?([A-Z]+)\\$?([0-9]+)";
    static final Pattern cellPattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?([A-Z]+)\\$?([0-9]+))");
    static final Pattern minCellPattern = Pattern.compile("\\$?([A-Z]+)\\$?([0-9]+)");
    static final Pattern cellRangePattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+)(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+))?");

    public static SpreadSheet createFromFile(File file) throws IOException {
        return SpreadSheet.create(new ODPackage(file));
    }

    public static SpreadSheet create(ODPackage oDPackage) {
        return new SpreadSheet(oDPackage.getDocument(ODPackage.RootElement.CONTENT.getZipEntry()), oDPackage.getDocument(ODPackage.RootElement.STYLES.getZipEntry()), oDPackage);
    }

    public static SpreadSheet createEmpty(TableModel tableModel) throws IOException {
        return SpreadSheet.createEmpty(tableModel, XMLVersion.getOD());
    }

    public static SpreadSheet createEmpty(TableModel tableModel, XMLVersion xMLVersion) throws IOException {
        ContentTypeVersioned contentTypeVersioned = ContentType.SPREADSHEET.getVersioned(xMLVersion);
        SpreadSheet spreadSheet = SpreadSheet.create(contentTypeVersioned.createPackage());
        spreadSheet.getBody().addContent(Sheet.createEmpty(xMLVersion));
        spreadSheet.getSheet(0).merge(tableModel, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel tableModel, File file, XMLVersion xMLVersion) throws IOException {
        return SpreadSheet.createEmpty(tableModel, xMLVersion).saveAs(file);
    }

    public SpreadSheet(Document document, Document document2) {
        this(document, document2, null);
    }

    private SpreadSheet(Document document, Document document2, ODPackage oDPackage) {
        this.originalFile = oDPackage != null ? oDPackage : new ODPackage();
        this.originalFile.putFile("content.xml", document);
        if (document2 != null) {
            this.originalFile.putFile("styles.xml", document2);
        }
        this.sheets = new HashMap<Element, Sheet>();
    }

    final Document getContent() {
        return this.getPackage().getContent().getDocument();
    }

    @Override
    public final XMLVersion getVersion() {
        return this.getPackage().getVersion();
    }

    private Element getBody() {
        return ContentType.SPREADSHEET.getVersioned(this.getVersion()).getBody(this.getContent());
    }

    protected static final String parseSheetName(String string) {
        if (string == null) {
            return null;
        }
        return string.charAt(0) == '$' ? string.substring(1) : string;
    }

    public final SheetTableModel.MutableTableModel<SpreadSheet> getTableModel(String string) {
        Element element;
        Object object;
        try {
            object = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + string + "']");
            element = (Element)((XPath)object).selectSingleNode(this.getBody());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException(jDOMException);
        }
        if (element == null) {
            return null;
        }
        object = element.getAttributeValue("cell-range-address", this.getVersion().getTABLE());
        Range range = Range.parse((String)object);
        if (range.spanSheets()) {
            throw new UnsupportedOperationException("different sheet names: " + range.getStartSheet() + " != " + range.getEndSheet());
        }
        Sheet sheet = this.getSheet(range.getStartSheet(), true);
        return sheet.getMutableTableModel(range.getStartPoint(), range.getEndPoint());
    }

    public final Cell<SpreadSheet> getCellAt(String string) {
        Matcher matcher = cellPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string + " is not a valid cell address: " + matcher.pattern().pattern());
        }
        String string2 = SpreadSheet.parseSheetName(matcher.group(1));
        if (string2 == null) {
            throw new IllegalArgumentException("no sheet specified: " + string);
        }
        return this.getSheet(string2, true).getCellAt(Sheet.resolve(matcher.group(5), matcher.group(6)));
    }

    public XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    private final List<Element> getTables() {
        return this.getBody().getChildren("table", this.getVersion().getTABLE());
    }

    public int getSheetCount() {
        return this.getTables().size();
    }

    public Sheet getSheet(int n) {
        return this.getSheet(this.getTables().get(n));
    }

    public Sheet getSheet(String string) {
        return this.getSheet(string, false);
    }

    public Sheet getSheet(String string, boolean bl) throws NoSuchElementException {
        for (Element element : this.getTables()) {
            if (!string.equals(Table.getName(element))) continue;
            return this.getSheet(element);
        }
        if (bl) {
            throw new NoSuchElementException("no such sheet: " + string);
        }
        return null;
    }

    private final Sheet getSheet(Element element) {
        Sheet sheet = this.sheets.get(element);
        if (sheet == null) {
            sheet = new Sheet(this, element);
            this.sheets.put(element, sheet);
        }
        return sheet;
    }

    void invalidate(Element element) {
        this.sheets.remove(element);
    }

    public final Sheet addSheet(int n, String string) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        Element element = Table.createEmpty(this.getVersion());
        return this.addSheet(n, element, string);
    }

    final Sheet addSheet(int n, Element element, String string) {
        this.getBody().addContent(this.getContentIndex(n), element);
        Sheet sheet = this.getSheet(element);
        if (string != null) {
            sheet.setName(string);
        }
        assert (sheet.getName() != null);
        return sheet;
    }

    private final int getContentIndex(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n);
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(this.getTables());
        if (n > arrayList.size()) {
            throw new IndexOutOfBoundsException("index (" + n + ") > count (" + arrayList.size() + ")");
        }
        int n2 = n == arrayList.size() ? this.getBody().indexOf((Content)arrayList.get(n - 1)) + 1 : this.getBody().indexOf((Content)arrayList.get(n));
        return n2;
    }

    public final Sheet addSheet(String string) {
        return this.addSheet(this.getSheetCount(), string);
    }

    void move(Sheet sheet, int n) {
        Element element = sheet.getElement().getParentElement();
        sheet.getElement().detach();
        element.addContent(this.getContentIndex(n), sheet.getElement());
    }

    public File saveAs(File file) throws FileNotFoundException, IOException {
        this.getPackage().setFile(file);
        return this.getPackage().save();
    }

    @Override
    public final ODPackage getPackage() {
        return this.originalFile;
    }
}

