/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import junit.framework.TestCase;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyledNode;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Range;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.style.SideStyleProperties;
import org.jopendocument.dom.text.Paragraph;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.util.Tuple2;
import org.jopendocument.util.Validator;

public class SheetTest
extends TestCase {
    static final DefaultTableModel tm = new DefaultTableModel();
    private Sheet sheet;
    private Sheet realSheet;

    protected void setUp() throws Exception {
        this.sheet = SpreadSheet.createEmpty(tm, XMLVersion.getOOo()).getSheet(0);
        this.realSheet = SpreadSheet.create(new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.ods"))).getSheet(0);
    }

    protected void tearDown() throws Exception {
        this.sheet = null;
        this.realSheet = null;
    }

    public void testCreate() throws IOException {
        Object object;
        Object object2;
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            object2 = SpreadSheet.createEmpty(defaultTableModel, xMLVersion);
            object = ((SpreadSheet)object2).getPackage().getContent().getValidator();
            this.assertValid((SpreadSheet)object2);
            this.assertValid((Validator)object);
            SheetTest.assertEquals((int)0, (int)((Validator)object).validateCompletely().size());
            ((SpreadSheet)object2).getSheet(0).getElement().removeContent();
            this.assertValid((SpreadSheet)object2, false);
            this.assertValid((Validator)object, false);
            SheetTest.assertTrue((((Validator)object).validateCompletely().size() > 0 ? 1 : 0) != 0);
        }
        DefaultTableModel defaultTableModel2 = new DefaultTableModel(new Object[][]{{"Data", "DataCol2"}}, new Object[]{"Col1", "Col2"});
        SpreadSheet spreadSheet = SpreadSheet.createEmpty(defaultTableModel2);
        this.assertValid(spreadSheet);
        File file = File.createTempFile("testCreate", "." + spreadSheet.getPackage().getContentType().getExtension());
        File file2 = spreadSheet.saveAs(file);
        file2.deleteOnExit();
        if (!file.equals(file2)) {
            file.delete();
            SheetTest.fail((String)("Wrong extension : " + file));
        }
        object2 = SpreadSheet.createFromFile(file2).getSheet(0);
        SheetTest.assertEquals((int)2, (int)((Table)object2).getRowCount());
        SheetTest.assertEquals((Object)"Col1", (Object)((Table)object2).getValueAt("A1"));
        object = ((Table)object2).getTableModel(0, 1);
        SheetTest.assertEquals((int)2, (int)((SheetTableModel)object).getColumnCount());
        SheetTest.assertEquals((int)1, (int)((SheetTableModel)object).getRowCount());
        SheetTest.assertEquals((Object)"DataCol2", (Object)((SheetTableModel)object).getValueAt(0, 1));
    }

    public void testName() throws Exception {
        int n;
        int n2;
        SpreadSheet spreadSheet = this.realSheet.getSpreadSheet();
        SheetTest.assertEquals((String)"users", (String)spreadSheet.getSheet("users").getName());
        SheetTest.assertFalse((boolean)"newName".equals(this.realSheet.getName()));
        this.realSheet.setName("newName");
        SheetTest.assertTrue((boolean)"newName".equals(this.realSheet.getName()));
        SheetTest.assertSame((Object)this.realSheet, (Object)spreadSheet.getSheet("newName"));
        SheetTest.assertEquals((int)2, (int)spreadSheet.getSheetCount());
        Sheet sheet = spreadSheet.getSheet(0);
        Sheet sheet2 = spreadSheet.getSheet(1);
        Sheet sheet3 = spreadSheet.addSheet(2, "newSheet");
        SheetTest.assertEquals((int)3, (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet("newSheet"));
        SheetTest.assertSame((Object)sheet, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(2));
        sheet3.ensureRowCount(8);
        sheet3.ensureColumnCount(10);
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 8; ++n) {
                sheet3.setValueAt(n2 + "," + n, n2, n);
            }
        }
        this.assertValid(this.realSheet.getSpreadSheet());
        for (n2 = 0; n2 < 3; ++n2) {
            sheet3.move(n2);
            SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(n2));
        }
        sheet3.move(0);
        SheetTest.assertEquals((int)3, (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet("newSheet"));
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(2));
        this.assertValid(this.realSheet.getSpreadSheet());
        Sheet sheet4 = sheet3.copy(2, "copiedSheet");
        SheetTest.assertEquals((int)4, (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet4, (Object)spreadSheet.getSheet("copiedSheet"));
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet4, (Object)spreadSheet.getSheet(2));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(3));
        this.assertValid(this.realSheet.getSpreadSheet());
        n = spreadSheet.getSheetCount();
        SheetTest.assertSame((Object)sheet, (Object)this.realSheet);
        this.realSheet.detach();
        SheetTest.assertNull((Object)spreadSheet.getSheet(this.realSheet.getName()));
        SheetTest.assertEquals((int)(n - 1), (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet4, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(2));
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testSetValueAt() throws Exception {
        SheetTest.assertEquals((Object)"col1", (Object)this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt("test", 0, 0);
        SheetTest.assertEquals((Object)"test", (Object)this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt(6.00013991523E7, 0, 0);
        SheetTest.assertEquals((Object)new BigDecimal("60001399.1523"), (Object)this.sheet.getValueAt(0, 0));
        Calendar calendar = Calendar.getInstance();
        this.sheet.setValueAt(calendar.getTime(), 0, 0);
        Object object = this.sheet.getValueAt(0, 0);
        SheetTest.assertEquals((Object)calendar.getTime(), (Object)object);
        this.assertValid(this.sheet.getSpreadSheet());
        try {
            this.realSheet.getCellAt("C3");
            SheetTest.fail((String)"should have failed since C3 is covered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.realSheet.getCellAt("B3").unmerge();
        this.realSheet.getCellAt("C3").setValue(new Date());
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("../test.odt")).toSingle();
        Table<ODSingleXMLDocument> table = new Table<ODSingleXMLDocument>(oDSingleXMLDocument, oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable"));
        MutableCell<ODSingleXMLDocument> mutableCell = table.getCellAt(2, 1);
        SheetTest.assertEquals((String)"end", (String)this.getFirstPStyle(mutableCell).getAlignment());
        mutableCell.setValue("somethingElse");
        SheetTest.assertEquals((String)"end", (String)this.getFirstPStyle(mutableCell).getAlignment());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    private final ParagraphStyle getFirstPStyle(Cell<ODSingleXMLDocument> cell) {
        Paragraph paragraph = new Paragraph(cell.getElement().getChild("p", cell.getNS().getTEXT()));
        paragraph.setDocument((ODSingleXMLDocument)cell.getODDocument());
        return (ParagraphStyle)paragraph.getStyle();
    }

    public void testGetValueAt() {
        SheetTest.assertEquals((Object)new BigDecimal(123), (Object)this.sheet.getValueAt(2, 1));
        SheetTest.assertEquals((Object)new BigDecimal(123), (Object)this.sheet.getValueAt("C2"));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2008, 11, 25);
        Cell cell = this.realSheet.getImmutableCellAt("F3");
        SheetTest.assertEquals((Object)calendar.getTime(), (Object)cell.getValue());
        SheetTest.assertEquals((String)"25 d\u00e9c. 2008", (String)cell.getTextValue());
        Cell cell2 = this.realSheet.getImmutableCellAt("B3");
        SheetTest.assertEquals((Object)"Gestion\tdes droits\nnouvelle  arborescence ", (Object)cell2.getValue());
        SheetTest.assertEquals((String)"Gestion\tdes droits\nnouvelle  arborescence ", (String)cell2.getTextValue(true));
        cell2.getElement().removeContent();
        Element element = new Element("p", cell2.getElement().getNamespace("text"));
        element.addContent("\n\t\tGestion \t des droits");
        cell2.getElement().addContent("\n\t").addContent(element).addContent("\n");
        SheetTest.assertEquals((String)"Gestion des droits", (String)cell2.getTextValue(false));
        SheetTest.assertSame(this.realSheet.getCellAt("F3"), this.realSheet.getSpreadSheet().getCellAt(this.realSheet.getName() + ".$F$3"));
    }

    public void testGetCount() {
        SheetTest.assertEquals((int)2, (int)this.sheet.getRowCount());
        SheetTest.assertEquals((int)3, (int)this.sheet.getColumnCount());
    }

    public void testEnsureColumnCount() {
        int n = this.sheet.getColumnCount();
        int n2 = n - 2;
        this.sheet.ensureColumnCount(n2);
        SheetTest.assertEquals((int)n, (int)this.sheet.getColumnCount());
    }

    public void testSetColumnCount() throws Exception {
        int n = this.sheet.getColumnCount() + 5;
        try {
            this.sheet.setValueAt("test", n - 1, 0);
            SheetTest.fail((String)"should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.sheet.setColumnCount(n);
        this.sheet.setValueAt("test", n - 1, 0);
        int n2 = this.realSheet.getColumnCount();
        try {
            this.realSheet.setValueAt("over", n2 + 10 - 1, 1);
            SheetTest.fail((String)"should throw exn since we try to write past the limit");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.realSheet.setColumnCount(n2 + 10);
        this.realSheet.setValueAt("over", n2 + 10 - 1, 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(15360);
        this.realSheet.getSpreadSheet().getPackage().save(byteArrayOutputStream);
        SpreadSheet spreadSheet = SpreadSheet.create(new ODPackage(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        SheetTest.assertEquals((Object)"over", (Object)spreadSheet.getSheet(0).getValueAt(n2 + 10 - 1, 1));
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testRemoveCol() throws Exception {
        this.realSheet.setColumnCount(9, -1, true);
        SheetTest.assertEquals((int)9, (int)this.realSheet.getColumnCount());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        this.realSheet.removeColumn(1, true);
        SheetTest.assertEquals((int)8, (int)this.realSheet.getColumnCount());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("../test.odt")).toSingle();
        Table<ODSingleXMLDocument> table = new Table<ODSingleXMLDocument>(oDSingleXMLDocument, oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable"));
        float f = table.getColumn(1).getWidth().floatValue();
        float f2 = table.getWidth().floatValue();
        table.removeColumn(1, false);
        SheetTest.assertTrue((Math.abs(f2 - f - table.getWidth().floatValue()) <= Math.ulp(table.getWidth().floatValue()) ? 1 : 0) != 0);
        f2 = table.getWidth().floatValue();
        table.removeColumn(1, true);
        SheetTest.assertEquals((Object)Float.valueOf(f2), (Object)table.getWidth());
    }

    public void testSetRowCount() throws IOException {
        this.realSheet.setRowCount(3);
        SpreadSheet spreadSheet = new SpreadSheet(((SpreadSheet)this.realSheet.getODDocument()).getContent(), null);
        SheetTest.assertEquals((int)3, (int)spreadSheet.getSheet(0).getRowCount());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testGetTableModel() {
        SheetTableModel sheetTableModel = this.sheet.getTableModel(1, 0);
        SheetTest.assertEquals((int)(tm.getColumnCount() - 1), (int)sheetTableModel.getColumnCount());
        SheetTest.assertEquals((int)(tm.getRowCount() + 1), (int)sheetTableModel.getRowCount());
        SheetTest.assertEquals((Object)new BigDecimal("-5.320"), (Object)sheetTableModel.getValueAt(1, 0));
        SheetTest.assertNull(sheetTableModel.getImmutableCellAt(0, 0).getStyle());
        try {
            sheetTableModel.getValueAt(1, sheetTableModel.getColumnCount());
            SheetTest.fail((String)"should have thrown exn");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetMutableTableModel() {
        this.sheet.getMutableTableModel(1, 0).setValueAt("test", 0, 1);
        SheetTest.assertEquals((Object)"test", (Object)this.sheet.getCellAt("C1").getValue());
        SheetTableModel.MutableTableModel<SpreadSheet> mutableTableModel = this.realSheet.getSpreadSheet().getTableModel("rights");
        SheetTest.assertEquals((Object)"K1", (Object)mutableTableModel.getValueAt(13, 6));
        SheetTest.assertEquals((Object)Color.CYAN, (Object)((CellStyle)mutableTableModel.getCellAt(0, 0).getStyle()).getBackgroundColor());
        SheetTest.assertEquals((String)"#ffcc99", (String)((CellStyle)mutableTableModel.getCellAt(1, 2).getStyle()).getTableCellProperties().getRawBackgroundColor());
        try {
            mutableTableModel.setValueAt("foo", 0, mutableTableModel.getColumnCount());
            SheetTest.fail((String)"should have thrown exn");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testMerge() throws IOException {
        MutableCell mutableCell = this.realSheet.getCellAt("B3");
        SheetTest.assertEquals((int)2, (int)mutableCell.getColumnsSpanned());
        SheetTest.assertEquals((int)1, (int)mutableCell.getRowsSpanned());
        mutableCell.unmerge();
        SheetTest.assertEquals((int)1, (int)mutableCell.getColumnsSpanned());
        SheetTest.assertEquals((int)1, (int)mutableCell.getRowsSpanned());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("B4").isValid());
        mutableCell.merge(3, 2);
        SheetTest.assertEquals((int)3, (int)mutableCell.getColumnsSpanned());
        SheetTest.assertEquals((int)2, (int)mutableCell.getRowsSpanned());
        SheetTest.assertTrue((boolean)mutableCell.isValid());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("B4").isValid());
        try {
            this.realSheet.getCellAt("C3");
            SheetTest.fail((String)"should have thrown an exn");
        }
        catch (Exception exception) {
            // empty catch block
        }
        mutableCell.merge(3, 3);
        SheetTest.assertEquals((int)3, (int)mutableCell.getColumnsSpanned());
        SheetTest.assertEquals((int)3, (int)mutableCell.getRowsSpanned());
        mutableCell.merge(1, 3);
        SheetTest.assertEquals((int)1, (int)mutableCell.getColumnsSpanned());
        SheetTest.assertEquals((int)3, (int)mutableCell.getRowsSpanned());
        SheetTest.assertTrue((boolean)mutableCell.isValid());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("B4").isValid());
        try {
            this.realSheet.getCellAt(0, 0).merge(2, 4);
            SheetTest.fail((String)"Allowed overlapping merge");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt(0, 0).coversOtherCells());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt(0, 1).isValid());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testResolve() {
        this.testResolve(new Point(0, 22), "A23");
        this.testResolve(new Point(26, 33), "AA34");
        this.testResolve(new Point(106, 11), "DC12");
        SheetTest.assertNull((Object)Sheet.resolve("A23A"));
        SheetTest.assertNull((Object)Sheet.resolve("test"));
        SheetTest.assertNull((Object)Sheet.resolve("23"));
        SheetTest.assertEquals((int)77, (int)Sheet.toInt("BZ"));
        Range range = Range.parse("Sheet1.A23:.AA34");
        SheetTest.assertFalse((boolean)range.spanSheets());
        SheetTest.assertEquals((String)"Sheet1", (String)range.getStartSheet());
        SheetTest.assertEquals((String)"Sheet1", (String)range.getEndSheet());
        SheetTest.assertEquals((Object)Sheet.resolve("A23"), (Object)range.getStartPoint());
        SheetTest.assertEquals((Object)Sheet.resolve("AA34"), (Object)range.getEndPoint());
        SheetTest.assertEquals((Object)range, (Object)Range.parse(range.toString()));
    }

    private void testResolve(Point point, String string) {
        SheetTest.assertEquals((Object)point, (Object)Sheet.resolve(string));
        SheetTest.assertEquals((String)string, (String)Sheet.getAddress(point));
    }

    public void testDuplicateRows() throws Exception {
        this.realSheet.duplicateRows(8, 3, 2);
        SheetTest.assertEquals((Object)this.realSheet.getValueAt("B11"), (Object)this.realSheet.getValueAt("B14"));
        SheetTest.assertEquals((Object)"Comptabilit\u00e9", (Object)this.realSheet.getValueAt("H9"));
        SheetTest.assertEquals((Object)this.realSheet.getValueAt("H9"), (Object)this.realSheet.getValueAt("H12"));
        SheetTest.assertEquals((Object)this.realSheet.getValueAt("H9"), (Object)this.realSheet.getValueAt("H15"));
        this.assertValid(this.realSheet.getSpreadSheet());
        SheetTest.assertEquals((int)2, (int)this.sheet.getRowCount());
        this.sheet.duplicateRows(1, 1, 3);
        SheetTest.assertEquals((int)5, (int)this.sheet.getRowCount());
        SheetTest.assertEquals((Object)this.sheet.getValueAt("C2"), (Object)this.sheet.getValueAt("C4"));
    }

    public void testXY() throws Exception {
        MutableCell mutableCell = this.realSheet.getCellAt(2, 35);
        SheetTest.assertEquals((Object)"LECTURE SEULE", (Object)mutableCell.getValue());
        SheetTest.assertEquals((int)2, (int)mutableCell.getX());
        SheetTest.assertEquals((int)35, (int)mutableCell.getY());
        this.realSheet.duplicateRows(8, 3, 2);
        mutableCell = this.realSheet.getCellAt(2, 41);
        SheetTest.assertEquals((Object)"LECTURE SEULE", (Object)mutableCell.getValue());
        SheetTest.assertEquals((int)2, (int)mutableCell.getX());
        SheetTest.assertEquals((int)41, (int)mutableCell.getY());
    }

    public void testStyle() throws Exception {
        SheetTest.assertNull((Object)this.realSheet.getImmutableCellAt(2, 10).getStyleAttr());
        String string = this.realSheet.getStyleNameAt(2, 10);
        SheetTest.assertNotNull((Object)string);
        SheetTest.assertEquals((Object)Color.CYAN, (Object)((CellStyle)this.realSheet.getCellAt(2, 10).getStyle()).getBackgroundColor());
        SheetTest.assertEquals((String)string, (String)this.realSheet.getCellAt(2, 10).getStyleName());
        MutableCell mutableCell = this.realSheet.getCellAt(0, 0);
        SheetTest.assertNull((Object)mutableCell.getStyleAttr());
        SheetTest.assertFalse((boolean)((CellStyle)mutableCell.getStyle()).getReferences().contains(mutableCell.getElement()));
        SheetTest.assertTrue((boolean)this.realSheet.getStyleReferences(this.realSheet.getStyleNameAt(0, 0)).contains(Tuple2.create(0, 0)));
        Object object = (CellStyle)this.realSheet.getCellAt("B9").getStyle();
        SheetTest.assertTrue((boolean)((Style)object).getReferences().contains(this.realSheet.getCellAt("B9").getElement()));
        SheetTest.assertEquals((String)"center", (String)((CellStyle)object).getParagraphProperties().getAlignment());
        SheetTest.assertEquals((String)"bold", (String)((CellStyle)object).getTextProperties().getWeight());
        SheetTest.assertEquals((String)"0.002cm solid #000000", (String)((CellStyle)object).getTableCellProperties().getBorder(SideStyleProperties.Side.LEFT));
        SheetTest.assertEquals(null, (Object)((CellStyle)object).getTableCellProperties().getBorderLineWidth(SideStyleProperties.Side.LEFT));
        SheetTest.assertEquals((int)0, (int)((CellStyle)object).getTableCellProperties().getRotationAngle());
        SheetTest.assertEquals((boolean)true, (boolean)((CellStyle)object).getTableCellProperties().isContentPrinted());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isContentRepeated());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isShrinkToFit());
        object = (CellStyle)this.realSheet.getCellAt("B6").getStyle();
        SheetTest.assertTrue((boolean)((Style)object).getReferences().contains(this.realSheet.getCellAt("B6").getElement()));
        SheetTest.assertEquals((String)"start", (String)((CellStyle)object).getParagraphProperties().getAlignment());
        SheetTest.assertEquals(null, (String)((CellStyle)object).getTextProperties().getWeight());
        SheetTest.assertEquals((String)"0.105cm double #000080", (String)((CellStyle)object).getTableCellProperties().getBorder(SideStyleProperties.Side.RIGHT));
        SheetTest.assertEquals((String)"none", (String)((CellStyle)object).getTableCellProperties().getBorder(SideStyleProperties.Side.TOP));
        SheetTest.assertEquals(Arrays.asList("0.035cm", "0.035cm", "0.035cm"), Arrays.asList(((CellStyle)object).getTableCellProperties().getBorderLineWidth(SideStyleProperties.Side.RIGHT)));
        SheetTest.assertEquals((int)333, (int)((CellStyle)object).getTableCellProperties().getRotationAngle());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isContentPrinted());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isContentRepeated());
        SheetTest.assertEquals((boolean)true, (boolean)((CellStyle)object).getTableCellProperties().isShrinkToFit());
        SheetTest.assertNull((Object)((CellStyle)CellStyle.DESC.createAutoStyle(this.sheet.getSpreadSheet().getPackage())).getBackgroundColor());
        SheetTest.assertEquals((Object)Float.valueOf(54.38f), (Object)this.realSheet.getColumn(1).getWidth());
        object = SpreadSheet.create(new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.sxc")));
        SheetTest.assertEquals((Object)Float.valueOf(33.85f), (Object)((SpreadSheet)object).getSheet(0).getColumn(1).getWidth());
        ODNode oDNode = this.realSheet.getColumn(9);
        Object object2 = this.realSheet.getColumn(10);
        SheetTest.assertEquals((String)((ColumnStyle)((StyledNode)oDNode).getStyle()).getName(), (String)((ColumnStyle)((StyledNode)object2).getStyle()).getName());
        this.checkStyleElements((Column<SpreadSheet>)oDNode, (Column<SpreadSheet>)object2, true);
        SheetTest.assertNotNull((Object)((ColumnStyle)((StyledNode)oDNode).getStyle()).getBreakBefore());
        float f = ((Column)object2).getWidth().floatValue();
        ((Column)oDNode).setWidth(Float.valueOf(f + 15.0f));
        SheetTest.assertEquals((Object)Float.valueOf(f + 15.0f), (Object)((Column)oDNode).getWidth());
        SheetTest.assertEquals((Object)Float.valueOf(f), (Object)((Column)object2).getWidth());
        SheetTest.assertEquals((String)((ColumnStyle)((StyledNode)object2).getStyle()).getBreakBefore(), (String)((ColumnStyle)((StyledNode)oDNode).getStyle()).getBreakBefore());
        String string2 = ((ColumnStyle)((StyledNode)oDNode).getStyle()).getName();
        SheetTest.assertFalse((boolean)string2.equals(((ColumnStyle)((StyledNode)object2).getStyle()).getName()));
        this.checkStyleElements((Column<SpreadSheet>)oDNode, (Column<SpreadSheet>)object2, false);
        ((Column)oDNode).setWidth(Float.valueOf(f + 17.0f));
        SheetTest.assertEquals((String)string2, (String)((ColumnStyle)((StyledNode)oDNode).getStyle()).getName());
        Sheet sheet = this.realSheet.getSpreadSheet().addSheet("testEmptyStyle");
        SheetTest.assertNull(sheet.getColumn(0).getStyle());
        sheet.getColumn(0).setWidth(20);
        ColumnStyle columnStyle = (ColumnStyle)sheet.getColumn(0).getStyle();
        SheetTest.assertNotNull((Object)columnStyle);
        SheetTest.assertEquals((String)columnStyle.getName(), (String)((ColumnStyle)sheet.getColumn(0).getPrivateStyle()).getName());
        SheetTest.assertEquals((Object)Float.valueOf(20.0f), (Object)sheet.getColumn(0).getWidth());
        SheetTest.assertEquals((String)"Default", (String)this.sheet.getStyleNameAt(0, 0));
        SheetTest.assertEquals((String)"Default", (String)this.sheet.getStyleNameAt(0, 1));
        oDNode = (CellStyle)CellStyle.DESC.createAutoStyle(this.sheet.getSpreadSheet().getPackage(), "defaultCell");
        object2 = this.sheet.getColumn(0).getElement();
        ((Element)object2).setAttribute("default-cell-style-name", ((Style)oDNode).getName(), ((Element)object2).getNamespace());
        SheetTest.assertEquals((String)((Style)oDNode).getName(), (String)this.sheet.getStyleNameAt(0, 0));
        SheetTest.assertEquals((String)((Style)oDNode).getName(), (String)this.sheet.getStyleNameAt(0, 1));
        SheetTest.assertEquals(Collections.singletonList(object2), ((Style)oDNode).getReferences());
        SheetTest.assertNull((Object)((CellStyle)oDNode).getBackgroundColor());
        this.sheet.getCellAt(0, 0).setBackgroundColor(Color.CYAN);
        CellStyle cellStyle = this.sheet.getStyleAt(0, 0);
        SheetTest.assertFalse((boolean)((Style)oDNode).getName().equals(cellStyle.getName()));
        SheetTest.assertEquals((String)((Style)oDNode).getName(), (String)this.sheet.getStyleNameAt(0, 1));
        SheetTest.assertEquals((Object)Color.CYAN, (Object)cellStyle.getTableCellProperties().getBackgroundColor());
        SheetTest.assertNull((Object)this.sheet.getStyleAt(0, 1).getBackgroundColor());
        this.sheet.getCellAt(0, 0).setBackgroundColor(Color.YELLOW);
        SheetTest.assertEquals((String)cellStyle.getName(), (String)this.sheet.getStyleNameAt(0, 0));
        this.assertValid(this.sheet.getSpreadSheet());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    private void checkStyleElements(Column<SpreadSheet> column, Column<SpreadSheet> column2, boolean bl) {
        Attribute attribute = column.getElement().getAttribute("style-name", column.getElement().getNamespace());
        SheetTest.assertSame((Object)((ColumnStyle)column.getStyle()).getElement(), (Object)Style.getReferencedStyleElement(this.realSheet.getSpreadSheet().getPackage(), attribute));
        Attribute attribute2 = column2.getElement().getAttribute("style-name", column2.getElement().getNamespace());
        SheetTest.assertSame((Object)((ColumnStyle)column2.getStyle()).getElement(), (Object)Style.getReferencedStyleElement(this.realSheet.getSpreadSheet().getPackage(), attribute2));
        if (bl) {
            SheetTest.assertSame((Object)((ColumnStyle)column.getStyle()).getElement(), (Object)((ColumnStyle)column2.getStyle()).getElement());
        } else {
            SheetTest.assertNotSame((Object)((ColumnStyle)column.getStyle()).getElement(), (Object)((ColumnStyle)column2.getStyle()).getElement());
        }
    }

    private void assertValid(SpreadSheet spreadSheet) {
        this.assertValid(spreadSheet, true);
    }

    private void assertValid(SpreadSheet spreadSheet, boolean bl) {
        Map<String, String> map = spreadSheet.getPackage().validateSubDocuments();
        SheetTest.assertEquals((String)(map + ""), (boolean)bl, (boolean)map.isEmpty());
    }

    private void assertValid(Validator validator) {
        this.assertValid(validator, true);
    }

    private void assertValid(Validator validator, boolean bl) {
        String string = validator.isValid();
        if (bl) {
            SheetTest.assertNull((String)string, (Object)string);
        } else {
            SheetTest.assertNotNull((String)string, (Object)string);
        }
    }

    static {
        tm.addColumn("col1");
        tm.addColumn("col2");
        tm.addColumn("col3");
        tm.addRow(new Object[]{"un1", new BigDecimal("-5.320"), new Integer(123)});
    }
}

