/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.util.regex.Matcher;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.spreadsheet.Table;

public final class Range {
    private final String sheet1;
    private final String sheet2;
    private final Point start;
    private final Point end;

    public static final Range parse(String string) {
        Matcher matcher = SpreadSheet.cellRangePattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalStateException(string + " is not a valid range address");
        }
        String string2 = SpreadSheet.parseSheetName(matcher.group(1));
        String string3 = SpreadSheet.parseSheetName(matcher.group(6));
        Point point = Table.resolve(matcher.group(4));
        Point point2 = Table.resolve(matcher.group(9));
        return new Range(string2, point, string3, point2);
    }

    public Range(String string, Point point, String string2, Point point2) {
        if (string == null) {
            throw new NullPointerException("null sheet");
        }
        this.sheet1 = string;
        this.sheet2 = string2 == null ? string : string2;
        this.start = point;
        this.end = point2;
    }

    public final String getStartSheet() {
        return this.sheet1;
    }

    public final Point getStartPoint() {
        return this.start;
    }

    public final String getEndSheet() {
        return this.sheet2;
    }

    public final Point getEndPoint() {
        return this.end;
    }

    public final boolean spanSheets() {
        return !this.getStartSheet().equals(this.getEndSheet());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Range range = (Range)object;
        return this.sheet1.equals(range.sheet1) && this.start.equals(range.start) && this.sheet2.equals(range.sheet2) && this.end.equals(range.end);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.sheet1 == null ? 0 : this.sheet1.hashCode());
        n = 31 * n + (this.start == null ? 0 : this.start.hashCode());
        n = 31 * n + (this.sheet2 == null ? 0 : this.sheet2.hashCode());
        n = 31 * n + (this.end == null ? 0 : this.end.hashCode());
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getStartSheet());
        stringBuilder.append(".");
        stringBuilder.append(Table.getAddress(this.getStartPoint()));
        stringBuilder.append(":");
        if (this.spanSheets()) {
            stringBuilder.append(this.getEndSheet());
        }
        stringBuilder.append(".");
        stringBuilder.append(Table.getAddress(this.getEndPoint()));
        return stringBuilder.toString();
    }
}

