/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.util.Arrays;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.style.SideStyleProperties;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextStyle;

public class CellStyle
extends StyleStyle {
    public static final StyleStyleDesc<CellStyle> DESC = new StyleStyleDesc<CellStyle>(CellStyle.class, XMLVersion.OD, "table-cell", "ce", "table", Arrays.asList("table:body", "table:covered-table-cell", "table:even-rows", "table:first-column", "table:first-row", "table:last-column", "table:last-row", "table:odd-columns", "table:odd-rows", "table:table-cell")){
        {
            this.getMultiRefElementsMap().putAll("table:default-cell-style-name", (String[])new String[]{"table:table-column", "table:table-row"});
        }

        @Override
        public CellStyle create(ODPackage oDPackage, Element element) {
            return new CellStyle(oDPackage, element);
        }
    };
    private StyleTableCellProperties cellProps;
    private TextStyle.StyleTextProperties textProps;
    private ParagraphStyle.StyleParagraphProperties pProps;

    public CellStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final Color getBackgroundColor() {
        return this.getTableCellProperties().getBackgroundColor();
    }

    public final StyleTableCellProperties getTableCellProperties() {
        if (this.cellProps == null) {
            this.cellProps = new StyleTableCellProperties(this);
        }
        return this.cellProps;
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.StyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.StyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public static class StyleTableCellProperties
    extends SideStyleProperties {
        public StyleTableCellProperties(StyleStyle styleStyle) {
            super(styleStyle, DESC.getFamily());
        }

        public final int getRotationAngle() {
            String string = this.getElement().getAttributeValue("rotation-angle", this.getElement().getNamespace("style"));
            return string == null ? 0 : Integer.parseInt(string);
        }

        public final boolean isContentPrinted() {
            return this.parseBoolean(this.getElement().getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }

        public final boolean isContentRepeated() {
            return this.parseBoolean(this.getElement().getAttributeValue("repeat-content", this.getElement().getNamespace("style")), false);
        }

        public final boolean isShrinkToFit() {
            return this.parseBoolean(this.getElement().getAttributeValue("shrink-to-fit", this.getElement().getNamespace("style")), false);
        }
    }
}

