/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;

public abstract class StyleStyleDesc<S extends StyleStyle>
extends StyleDesc<S> {
    static final String ELEMENT_NAME = "style";
    private final String family;

    static String getFamily(Element element) {
        assert (element.getName().equals(ELEMENT_NAME));
        return element.getAttributeValue("family", element.getNamespace(ELEMENT_NAME));
    }

    public static <C extends StyleStyle> StyleStyleDesc<C> copy(final StyleStyleDesc<C> styleStyleDesc, XMLVersion xMLVersion) {
        StyleStyleDesc styleStyleDesc2 = new StyleStyleDesc<C>(styleStyleDesc.getStyleClass(), xMLVersion, styleStyleDesc.getFamily(), styleStyleDesc.getBaseName()){

            @Override
            public C create(ODPackage oDPackage, Element element) {
                return (StyleStyle)styleStyleDesc.create(oDPackage, element);
            }
        };
        styleStyleDesc2.getRefElementsMap().putAll(styleStyleDesc.getRefElementsMap());
        styleStyleDesc2.getMultiRefElementsMap().putAll(styleStyleDesc.getMultiRefElementsMap());
        return styleStyleDesc2;
    }

    protected StyleStyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2, String string3) {
        this(clazz, xMLVersion, string, string2, string3, Collections.singletonList(string3 + ":" + string));
    }

    protected StyleStyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2, String string3, List<String> list) {
        this(clazz, xMLVersion, string, string2);
        this.getRefElementsMap().putAll((Object)(string3 + ":style-name"), list);
    }

    protected StyleStyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2) {
        super(clazz, xMLVersion, ELEMENT_NAME, string2);
        this.family = string;
    }

    public final String getFamily() {
        return this.family;
    }

    @Override
    protected void initStyle(Element element) {
        super.initStyle(element);
        element.setAttribute("family", this.getFamily(), element.getNamespace());
    }
}

