/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.awt.Color;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.Style;

public abstract class StyleProperties {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final String TRANSPARENT_NAME = "transparent";
    private final Style parentStyle;
    private final String propPrefix;

    public StyleProperties(Style style, String string) {
        this.parentStyle = style;
        this.propPrefix = string;
    }

    public final Style getParentStyle() {
        return this.parentStyle;
    }

    public final Element getElement() {
        return this.getParentStyle().getFormattingProperties(this.propPrefix);
    }

    protected final boolean parseBoolean(String string, boolean bl) {
        return string == null ? bl : Boolean.parseBoolean(string);
    }

    protected final Namespace getNS(String string) {
        return this.getParentStyle().getNS().getNS(string);
    }

    public final String getRawBackgroundColor() {
        return this.getElement().getAttributeValue("background-color", this.getNS("fo"));
    }

    public final Color getBackgroundColor() {
        String string = this.getRawBackgroundColor();
        if (string == null) {
            return null;
        }
        if (TRANSPARENT_NAME.equals(string)) {
            return TRANSPARENT;
        }
        return OOUtils.decodeRGB(string);
    }

    public final void setBackgroundColor(Color color) {
        this.setBackgroundColor(color.getAlpha() == TRANSPARENT.getAlpha() ? TRANSPARENT_NAME : OOUtils.encodeRGB(color));
    }

    public final void setBackgroundColor(String string) {
        this.getElement().setAttribute("background-color", string, this.getNS("fo"));
    }
}

