/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CollectionMap;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.cc.ITransformer;

public abstract class StyleDesc<S extends Style> {
    private static final ITransformer<String, String> Q_NAME_TRANSF = new ITransformer<String, String>(){

        @Override
        public String transformChecked(String string) {
            return "name() = '" + string + "'";
        }
    };
    private final Class<S> clazz;
    private final XMLVersion version;
    private final String elemName;
    private final String baseName;
    private final CollectionMap<String, String> refElements;
    private final CollectionMap<String, String> multiRefElements;
    private XPath refXPath;

    public static <C extends Style> StyleDesc<C> copy(final StyleDesc<C> styleDesc, XMLVersion xMLVersion) {
        if (styleDesc instanceof StyleStyleDesc) {
            StyleStyleDesc styleStyleDesc = StyleStyleDesc.copy((StyleStyleDesc)styleDesc, xMLVersion);
            return styleStyleDesc;
        }
        StyleDesc styleDesc2 = new StyleDesc<C>(styleDesc.getStyleClass(), xMLVersion, styleDesc.getElementName(), styleDesc.getBaseName()){

            @Override
            public C create(ODPackage oDPackage, Element element) {
                return styleDesc.create(oDPackage, element);
            }
        };
        styleDesc2.getRefElementsMap().putAll(styleDesc.getRefElementsMap());
        styleDesc2.getMultiRefElementsMap().putAll(styleDesc.getMultiRefElementsMap());
        return styleDesc2;
    }

    private static final String getXPath(Collection<Map.Entry<String, Collection<String>>> collection) {
        return CollectionUtils.join(collection, " or ", new ITransformer<Map.Entry<String, Collection<String>>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, Collection<String>> entry) {
                String string = CollectionUtils.join(entry.getValue(), " or ", Q_NAME_TRANSF);
                return "( @" + entry.getKey() + " = $name  and ( " + string + " ))";
            }
        });
    }

    protected StyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2, String string3, List<String> list) {
        this(clazz, xMLVersion, string, string2);
        this.getRefElementsMap().putAll((Object)(string3 + ":style-name"), list);
    }

    protected StyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2) {
        this.clazz = clazz;
        this.version = xMLVersion;
        this.elemName = string;
        this.baseName = string2;
        this.refElements = new CollectionMap();
        this.multiRefElements = new CollectionMap(4);
        this.refXPath = null;
    }

    public abstract S create(ODPackage var1, Element var2);

    final Class<S> getStyleClass() {
        return this.clazz;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final String getElementName() {
        return this.elemName;
    }

    public final String getBaseName() {
        return this.baseName;
    }

    private final XPath getRefXPath() {
        if (this.refXPath == null) {
            String string = "( $includeSingle and " + StyleDesc.getXPath(this.getRefElementsMap().entrySet()) + " )";
            String string2 = this.getMultiRefElementsMap().size() == 0 ? "" : " or ( $includeMulti and " + StyleDesc.getXPath(this.getMultiRefElementsMap().entrySet()) + " )";
            try {
                this.refXPath = OOUtils.getXPath("//*[ " + string + string2 + " ]", this.version);
            }
            catch (JDOMException jDOMException) {
                throw new IllegalStateException("couldn't create xpath with " + this.getRefElements(), jDOMException);
            }
        }
        return this.refXPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Element> getReferences(Document document, String string, boolean bl, boolean bl2) {
        XPath xPath = this.getRefXPath();
        try {
            XPath xPath2 = xPath;
            synchronized (xPath2) {
                xPath.setVariable("name", string);
                xPath.setVariable("includeSingle", bl);
                xPath.setVariable("includeMulti", bl2);
                return xPath.selectNodes(document);
            }
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException("unable to search for occurences of " + this, jDOMException);
        }
    }

    protected final Collection<String> getRefElements() {
        return this.getRefElementsMap().values();
    }

    protected final CollectionMap<String, String> getRefElementsMap() {
        return this.refElements;
    }

    protected final CollectionMap<String, String> getMultiRefElementsMap() {
        return this.multiRefElements;
    }

    public final S findStyle(ODPackage oDPackage, Document document, String string) {
        Element element = oDPackage.getStyle(document, this, string);
        return element == null ? null : (S)this.create(oDPackage, element);
    }

    public final S createAutoStyle(ODPackage oDPackage) {
        return this.createAutoStyle(oDPackage, this.getBaseName());
    }

    public final S createAutoStyle(ODPackage oDPackage, String string) {
        ODXMLDocument oDXMLDocument = oDPackage.getContent();
        Namespace namespace = oDXMLDocument.getVersion().getSTYLE();
        Element element = new Element(this.getElementName(), namespace);
        this.initStyle(element);
        element.setAttribute("name", oDXMLDocument.findUnusedName(this, string), namespace);
        oDXMLDocument.addAutoStyle(element);
        return this.create(oDPackage, element);
    }

    protected void initStyle(Element element) {
    }
}

