/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.GraphicStyle;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.TableStyle;
import org.jopendocument.dom.style.PageLayoutStyle;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextStyle;
import org.jopendocument.util.CollectionMap;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.Tuple2;

public class Style
extends ODNode {
    private static final Map<XMLVersion, Map<String, StyleDesc<?>>> family2Desc;
    private static final Map<XMLVersion, Map<String, StyleDesc<?>>> elemName2Desc;
    private static final Map<XMLVersion, Map<Class<? extends Style>, StyleDesc<?>>> class2Desc;
    private static boolean descsLoaded;
    private static final Map<XMLVersion, Map<Tuple2<String, String>, StyleDesc<?>>> attribute2Desc;
    private final StyleDesc<?> desc;
    private final ODPackage pkg;
    private final String name;
    private final XMLVersion ns;

    private static void loadDescs() {
        if (!descsLoaded) {
            Style.registerAllVersions(CellStyle.DESC);
            Style.registerAllVersions(RowStyle.DESC);
            Style.registerAllVersions(ColumnStyle.DESC);
            Style.registerAllVersions(TableStyle.DESC);
            Style.registerAllVersions(TextStyle.DESC);
            Style.registerAllVersions(ParagraphStyle.DESC);
            Style.register(GraphicStyle.DESC);
            Style.register(GraphicStyle.DESC_OO);
            Style.register(PageLayoutStyle.DESC);
            Style.register(PageLayoutStyle.DESC_OO);
            descsLoaded = true;
        }
    }

    private static void registerAllVersions(StyleDesc<? extends Style> styleDesc) {
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            if (xMLVersion == styleDesc.getVersion()) {
                Style.register(styleDesc);
                continue;
            }
            Style.register(StyleDesc.copy(styleDesc, xMLVersion));
        }
    }

    public static void register(StyleDesc<?> styleDesc) {
        if (styleDesc instanceof StyleStyleDesc) {
            StyleStyleDesc styleStyleDesc = (StyleStyleDesc)styleDesc;
            if (family2Desc.get((Object)styleDesc.getVersion()).put(styleStyleDesc.getFamily(), styleStyleDesc) != null) {
                throw new IllegalStateException(styleStyleDesc.getFamily() + " duplicate family");
            }
        } else if (elemName2Desc.get((Object)styleDesc.getVersion()).put(styleDesc.getElementName(), styleDesc) != null) {
            throw new IllegalStateException(styleDesc.getElementName() + " duplicate element name");
        }
        if (class2Desc.get((Object)styleDesc.getVersion()).put(styleDesc.getStyleClass(), styleDesc) != null) {
            throw new IllegalStateException(styleDesc.getStyleClass() + " duplicate");
        }
    }

    private static Collection<StyleDesc<?>> getDesc(XMLVersion xMLVersion) {
        Style.loadDescs();
        return class2Desc.get((Object)xMLVersion).values();
    }

    private static Map<Tuple2<String, String>, StyleDesc<?>> getAttr2Desc(XMLVersion xMLVersion) {
        Map<Tuple2<String, String>, StyleDesc<?>> map = attribute2Desc.get((Object)xMLVersion);
        if (map.isEmpty()) {
            for (StyleDesc<?> styleDesc : Style.getDesc(xMLVersion)) {
                Style.fillMap(map, styleDesc, styleDesc.getRefElementsMap());
                Style.fillMap(map, styleDesc, styleDesc.getMultiRefElementsMap());
            }
            assert (!map.isEmpty());
        }
        return map;
    }

    private static void fillMap(Map<Tuple2<String, String>, StyleDesc<?>> map, StyleDesc<?> styleDesc, CollectionMap<String, String> collectionMap) {
        for (Map.Entry<String, Collection<String>> entry : collectionMap.entrySet()) {
            for (String string : entry.getValue()) {
                Tuple2<String, String> tuple2 = Tuple2.create(string, entry.getKey());
                StyleDesc<?> styleDesc2 = map.put(tuple2, styleDesc);
                if (styleDesc2 == null) continue;
                throw new IllegalStateException("Duplicate desc for " + tuple2 + " : " + styleDesc2 + " and " + styleDesc);
            }
        }
    }

    public static Style warp(ODPackage oDPackage, Element element) {
        Style.loadDescs();
        String string = element.getName();
        if (string.equals("style")) {
            String string2 = StyleStyleDesc.getFamily(element);
            Map<String, StyleDesc<?>> map = family2Desc.get((Object)oDPackage.getVersion());
            if (map.containsKey(string2)) {
                StyleDesc<?> styleDesc = map.get(string2);
                return styleDesc.create(oDPackage, element);
            }
            return new StyleStyle(oDPackage, element);
        }
        Map<String, StyleDesc<?>> map = elemName2Desc.get((Object)oDPackage.getVersion());
        if (map.containsKey(string)) {
            StyleDesc<?> styleDesc = map.get(string);
            return styleDesc.create(oDPackage, element);
        }
        return new Style(oDPackage, element);
    }

    public static <S extends Style> S getStyle(ODPackage oDPackage, Class<S> clazz, String string) {
        StyleDesc<S> styleDesc = Style.getStyleDesc(clazz, oDPackage.getVersion());
        return styleDesc.create(oDPackage, oDPackage.getStyle(styleDesc, string));
    }

    public static Element getReferencedStyleElement(ODPackage oDPackage, Attribute attribute) {
        assert (attribute.getDocument() == oDPackage.getDocument(ODPackage.RootElement.CONTENT.getZipEntry()) || attribute.getDocument() == oDPackage.getDocument(ODPackage.RootElement.STYLES.getZipEntry())) : "attribute not defined in either the content or the styles of " + oDPackage;
        StyleDesc<?> styleDesc = Style.getAttr2Desc(oDPackage.getVersion()).get(Tuple2.create(attribute.getParent().getQualifiedName(), attribute.getQualifiedName()));
        if (styleDesc != null) {
            return oDPackage.getStyle(attribute.getDocument(), styleDesc, attribute.getValue());
        }
        return null;
    }

    public static <S extends Style> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion xMLVersion) {
        return Style.getStyleDesc(clazz, xMLVersion, true);
    }

    private static <S extends Style> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion xMLVersion, boolean bl) {
        Style.loadDescs();
        Map<Class<Style>, StyleDesc<?>> map = class2Desc.get((Object)xMLVersion);
        if (map.containsKey(clazz)) {
            return map.get(clazz);
        }
        if (bl) {
            throw new IllegalArgumentException("unregistered " + clazz + " for version " + (Object)((Object)xMLVersion));
        }
        return null;
    }

    protected static <S extends Style> StyleDesc<S> getNonNullStyleDesc(final Class<S> clazz, XMLVersion xMLVersion, final Element element, String string) {
        StyleDesc<S> styleDesc = Style.getStyleDesc(clazz, xMLVersion, false);
        if (styleDesc != null) {
            return styleDesc;
        }
        if (clazz == StyleStyle.class) {
            StyleStyleDesc<StyleStyle> styleStyleDesc = new StyleStyleDesc<StyleStyle>(StyleStyle.class, xMLVersion, StyleStyleDesc.getFamily(element), string){

                @Override
                public StyleStyle create(ODPackage oDPackage, Element element2) {
                    return new StyleStyle(oDPackage, element);
                }
            };
            return styleStyleDesc;
        }
        if (clazz == Style.class) {
            return new StyleDesc<S>(clazz, xMLVersion, element.getName(), string){

                @Override
                public S create(ODPackage oDPackage, Element element2) {
                    return (Style)clazz.cast(new Style(oDPackage, element));
                }
            };
        }
        throw new IllegalStateException("Unregistered class which is neither Style not StyleStyle :" + clazz);
    }

    public Style(ODPackage oDPackage, Element element) {
        super(element);
        this.pkg = oDPackage;
        this.name = this.getElement().getAttributeValue("name", this.getSTYLE());
        this.ns = this.pkg.getVersion();
        this.desc = Style.getNonNullStyleDesc(this.getClass(), this.ns, element, this.getName());
        if (!this.desc.getElementName().equals(this.getElement().getName())) {
            throw new IllegalArgumentException("expected " + this.desc.getElementName() + " but got " + this.getElement().getName() + " for " + element);
        }
        assert (this.pkg.getXMLFile(this.getElement().getDocument()) != null);
        assert (this.pkg.getVersion() == XMLVersion.getVersion(this.getElement()));
    }

    protected final Namespace getSTYLE() {
        return this.getElement().getNamespace("style");
    }

    public final XMLVersion getNS() {
        return this.ns;
    }

    public final String getName() {
        return this.name;
    }

    protected StyleDesc<?> getDesc() {
        return this.desc;
    }

    public Element getFormattingProperties() {
        return this.getFormattingProperties(this.getName());
    }

    public final Element getFormattingProperties(String string) {
        String string2 = this.getNS() == XMLVersion.OD ? string + "-properties" : "properties";
        Element element = this.getElement().getChild(string2, this.getSTYLE());
        if (element == null) {
            element = new Element(string2, this.getSTYLE());
            this.getElement().addContent(element);
        }
        return element;
    }

    private final List<Element> getReferences(Document document, boolean bl, boolean bl2) {
        return this.desc.getReferences(document, this.getName(), bl, bl2);
    }

    public final List<Element> getReferences() {
        return this.getReferences(true, true);
    }

    private final List<Element> getReferences(boolean bl, boolean bl2) {
        Document document = this.getElement().getDocument();
        Document document2 = this.pkg.getContent().getDocument();
        List<Element> list = this.getReferences(document, bl, bl2);
        if (document != document2 && !this.isAutomatic()) {
            list.addAll(this.getReferences(document2, bl, bl2));
        }
        return list;
    }

    private final boolean isAutomatic() {
        return this.getElement().getParentElement().getQualifiedName().equals("office:automatic-styles");
    }

    public final boolean isReferencedAtMostOnce() {
        return this.getReferences(false, true).size() == 0 && this.getReferences(true, false).size() <= 1;
    }

    public final Style dup() {
        ODXMLDocument oDXMLDocument = this.pkg.getXMLFile(this.getElement().getDocument());
        String string = oDXMLDocument.findUnusedName(this.desc, this.desc.getBaseName());
        Element element = (Element)this.getElement().clone();
        element.setAttribute("name", string, this.getSTYLE());
        JDOMUtils.insertAfter(this.getElement(), Collections.singleton(element));
        return this.desc.create(this.pkg, element);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Style)) {
            return false;
        }
        Style style = (Style)object;
        return this.getName().equals(style.getName()) && this.getElement().getName().equals(style.getElement().getName()) && this.getElement().getNamespace().equals(style.getElement().getNamespace());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getElement().getName().hashCode() + this.getElement().getNamespace().hashCode();
    }

    static {
        descsLoaded = false;
        int n = XMLVersion.values().length;
        family2Desc = new HashMap(n);
        elemName2Desc = new HashMap(n);
        class2Desc = new HashMap(n);
        attribute2Desc = new HashMap(n);
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            family2Desc.put(xMLVersion, new HashMap());
            elemName2Desc.put(xMLVersion, new HashMap());
            class2Desc.put(xMLVersion, new HashMap());
            attribute2Desc.put(xMLVersion, new HashMap(128));
        }
    }
}

