/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jdom.Element;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.GraphicStyle;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODFrame;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODUserDefinedMeta;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.style.PageLayoutStyle;
import org.jopendocument.dom.style.SideStyleProperties;
import org.jopendocument.dom.text.Heading;
import org.jopendocument.dom.text.Paragraph;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.util.CollectionUtils;

public class ODSingleXMLDocumentTest
extends TestCase {
    private static XMLVersion staticVersion;
    private final XMLVersion version;

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Test for ODSingleXMLDocument");
        XMLVersion[] xMLVersionArray = XMLVersion.values();
        int n = xMLVersionArray.length;
        for (int i = 0; i < n; ++i) {
            XMLVersion xMLVersion;
            staticVersion = xMLVersion = xMLVersionArray[i];
            testSuite.addTest((Test)new TestSuite(ODSingleXMLDocumentTest.class, xMLVersion.toString()));
        }
        return testSuite;
    }

    public ODSingleXMLDocumentTest() {
        this(staticVersion);
    }

    public ODSingleXMLDocumentTest(XMLVersion xMLVersion) {
        this.version = xMLVersion;
    }

    private ODPackage createPackage() throws IOException {
        return this.createPackage("test");
    }

    private ODPackage createPackage(String string) throws IOException {
        return new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream(string + "." + ContentType.TEXT.getVersioned(this.version).getExtension()));
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    private void assertValid(ODSingleXMLDocument oDSingleXMLDocument) {
        String string = oDSingleXMLDocument.getValidator().isValid();
        ODSingleXMLDocumentTest.assertNull((String)string, (Object)string);
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
    }

    public void testCreate() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = this.createPackage().toSingle();
        this.assertValid(oDSingleXMLDocument);
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            ODSingleXMLDocumentTest.assertEquals((boolean)contentTypeVersioned.isTemplate(), (contentTypeVersioned.getTemplate() == contentTypeVersioned ? 1 : 0) != 0);
            ODSingleXMLDocumentTest.assertEquals((!contentTypeVersioned.isTemplate() ? 1 : 0) != 0, (contentTypeVersioned.getNonTemplate() == contentTypeVersioned ? 1 : 0) != 0);
            if (contentTypeVersioned.isTemplate()) {
                ODSingleXMLDocumentTest.assertSame((Object)((Object)contentTypeVersioned), (Object)((Object)contentTypeVersioned.getNonTemplate().getTemplate()));
            } else if (contentTypeVersioned.getTemplate() != null) {
                ODSingleXMLDocumentTest.assertSame((Object)((Object)contentTypeVersioned), (Object)((Object)contentTypeVersioned.getTemplate().getNonTemplate()));
            }
            ODPackage oDPackage = contentTypeVersioned.createPackage();
            ODSingleXMLDocumentTest.assertEquals((int)0, (int)oDPackage.validateSubDocuments().size());
        }
    }

    public void testSplit() throws Exception {
        ODPackage oDPackage = this.createPackage();
        ODSingleXMLDocument oDSingleXMLDocument = oDPackage.toSingle();
        this.assertSingle(oDPackage, oDSingleXMLDocument);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32000);
        oDPackage.save(byteArrayOutputStream);
        ODSingleXMLDocumentTest.assertFalse((boolean)new ODPackage(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).isSingle());
        ODSingleXMLDocumentTest.assertTrue((boolean)oDPackage.split());
        ODSingleXMLDocumentTest.assertFalse((boolean)oDPackage.split());
        ODSingleXMLDocumentTest.assertTrue((boolean)oDSingleXMLDocument.isDead());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.getPackage());
        ODSingleXMLDocumentTest.assertFalse((boolean)oDPackage.isSingle());
        ODSingleXMLDocumentTest.assertEquals((int)0, (int)oDPackage.validateSubDocuments().size());
        this.assertSingle(oDPackage, oDPackage.toSingle());
    }

    private void assertSingle(ODPackage oDPackage, ODSingleXMLDocument oDSingleXMLDocument) {
        this.assertValid(oDSingleXMLDocument);
        ODSingleXMLDocumentTest.assertFalse((boolean)oDSingleXMLDocument.isDead());
        ODSingleXMLDocumentTest.assertSame((Object)oDPackage, (Object)oDSingleXMLDocument.getPackage());
        ODSingleXMLDocumentTest.assertTrue((boolean)oDPackage.isSingle());
    }

    public void testAdd() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("empty.odt")).toSingle();
        oDSingleXMLDocument.getBody().removeContent();
        ODSingleXMLDocument oDSingleXMLDocument2 = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("styles.odt")).toSingle();
        oDSingleXMLDocument.add(oDSingleXMLDocument2);
        this.assertValid(oDSingleXMLDocument);
    }

    public void testAddParagraph() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("styles.odt")).toSingle();
        Paragraph paragraph = new Paragraph();
        paragraph.setStyle("testPragraph");
        paragraph.addContent("Hello");
        paragraph.addTab();
        paragraph.addStyledContent("World", "testChar");
        ODSingleXMLDocumentTest.assertNull((Object)paragraph.getElement().getDocument());
        paragraph.setDocument(oDSingleXMLDocument);
        ODSingleXMLDocumentTest.assertSame((Object)oDSingleXMLDocument.getDocument(), (Object)paragraph.getElement().getDocument());
        Heading heading = new Heading();
        heading.setStyle("inexistantt");
        heading.addContent("Heading text");
        try {
            heading.setDocument(oDSingleXMLDocument);
            ODSingleXMLDocumentTest.fail((String)"should throw since style doesn't exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        heading.setStyle("testPragraph");
        Element element = paragraph.getElement().getParentElement();
        oDSingleXMLDocument.add(heading, element, element.indexOf(paragraph.getElement()));
        this.assertValid(oDSingleXMLDocument);
        paragraph.setDocument(null);
        ODSingleXMLDocumentTest.assertNull((Object)paragraph.getElement().getDocument());
    }

    public void testTable() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = this.createPackage().toSingle();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.getDescendantByName("table:table", "inexistant"));
        Element element = oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable");
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        Table<ODSingleXMLDocument> table = new Table<ODSingleXMLDocument>(oDSingleXMLDocument, element);
        ODSingleXMLDocumentTest.assertEquals((int)1, (int)table.getHeaderRowCount());
        ODSingleXMLDocumentTest.assertEquals((int)0, (int)table.getHeaderColumnCount());
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2005, 0, 12, 12, 35);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)table.getValueAt(2, 1));
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(119.06f), (Object)table.getWidth());
        table.setColumnCount(6, -1, true);
        table.setValueAt(3.14, 5, 0);
        this.assertTableWidth(table, 119.06f);
        float f = table.getColumn(0).getWidth().floatValue() / table.getColumn(1).getWidth().floatValue();
        table.setColumnCount(2, 1, true);
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(f), (Object)Float.valueOf(table.getColumn(0).getWidth().floatValue() / table.getColumn(1).getWidth().floatValue()));
        this.assertTableWidth(table, 119.06f);
        float f2 = table.getColumn(0).getWidth().floatValue();
        table.setColumnCount(4, 0, false);
        this.assertTableWidth(table, 119.06f + 2.0f * f2);
        table.setColumnCount(1, 123, false);
        ODSingleXMLDocumentTest.assertEquals((int)1, (int)table.getColumnCount());
        this.assertTableWidth(table, f2);
        this.assertValid(oDSingleXMLDocument);
        table.detach();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable"));
    }

    private void assertTableWidth(Table<?> table, float f) {
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(f), (Object)table.getWidth());
        float f2 = 0.0f;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            f2 += table.getColumn(i).getWidth().floatValue();
        }
        ODSingleXMLDocumentTest.assertEquals((long)this.round(f), (long)this.round(f2));
    }

    private long round(float f) {
        return Math.round((double)f * 100.0) / 100L;
    }

    public void testFrame() throws Exception {
        ODPackage oDPackage = this.createPackage();
        Element element = oDPackage.toSingle().getDescendantByName(ODFrame.getQualifiedName(oDPackage.getVersion()), "Cadre1");
        ODFrame<ODSingleXMLDocument> oDFrame = new ODFrame<ODSingleXMLDocument>(oDPackage.toSingle(), element);
        BigDecimal bigDecimal = this.version == XMLVersion.OOo ? new BigDecimal("42.73") : new BigDecimal("42.72");
        ODSingleXMLDocumentTest.assertEquals((Object)bigDecimal, (Object)oDFrame.getWidth());
        ODSingleXMLDocumentTest.assertNull((Object)oDFrame.getHeight());
        ODSingleXMLDocumentTest.assertEquals((String)"right", (String)((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().getHorizontalPosition());
        ODSingleXMLDocumentTest.assertEquals((String)"paragraph", (String)((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().getHorizontalRelation());
        ODSingleXMLDocumentTest.assertEquals(Arrays.asList("position"), ((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().getProtected());
        ODSingleXMLDocumentTest.assertTrue((boolean)((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().isContentPrinted());
    }

    public void testStyle() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        StyleDesc<ParagraphStyle> styleDesc = Style.getStyleDesc(ParagraphStyle.class, this.version);
        ODPackage oDPackage = this.createPackage();
        if (oDPackage.getVersion() != XMLVersion.OOo) {
            object4 = oDPackage.getContent().getXPath("//draw:ellipse[@draw:name = 'Ellipse']");
            object3 = (Element)((XPath)object4).selectSingleNode(oDPackage.getContent().getDocument());
            object2 = ((Element)object3).getAttributeValue("text-style-name", ((Element)object3).getNamespace("draw"));
            object = styleDesc.findStyle(oDPackage, oDPackage.getContent().getDocument(), (String)object2);
            ODSingleXMLDocumentTest.assertEquals(Collections.singletonList(object3), ((Style)object).getReferences());
        }
        object4 = oDPackage.getXMLFile("styles.xml");
        object3 = ((ODXMLDocument)object4).getXPath("//text:p[string() = 'Header']");
        object2 = (Element)((XPath)object3).selectSingleNode(((ODXMLDocument)object4).getDocument());
        object = new Paragraph((Element)object2).getStyleName();
        Element element = oDPackage.getStyle(oDPackage.getDocument("styles.xml"), styleDesc, (String)object);
        Element element2 = oDPackage.getStyle(oDPackage.getDocument("content.xml"), styleDesc, (String)object);
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        ODSingleXMLDocumentTest.assertNotNull((Object)element2);
        ODSingleXMLDocumentTest.assertNotSame((Object)element, (Object)element2);
        ODSingleXMLDocumentTest.assertEquals(Collections.singletonList(object2), StyleStyle.warp(oDPackage, element).getReferences());
        ODSingleXMLDocumentTest.assertFalse((boolean)StyleStyle.warp(oDPackage, element2).getReferences().contains(object2));
        PageLayoutStyle pageLayoutStyle = Style.getStyle(oDPackage, PageLayoutStyle.class, "pm1");
        ODSingleXMLDocumentTest.assertNull((Object)pageLayoutStyle.getBackgroundColor());
        ODSingleXMLDocumentTest.assertNull((Object)pageLayoutStyle.getPageLayoutProperties().getBorder(SideStyleProperties.Side.TOP));
        ODSingleXMLDocumentTest.assertEquals((Object)new BigDecimal(2), (Object)pageLayoutStyle.getPageLayoutProperties().getMargin(SideStyleProperties.Side.TOP, LengthUnit.CM));
        ODSingleXMLDocumentTest.assertSame(oDPackage.getXMLFile("styles.xml").getChild("master-styles").getChildren().get(0), (Object)CollectionUtils.getSole(pageLayoutStyle.getReferences()));
        oDPackage.toSingle();
        ODSingleXMLDocumentTest.assertSame((Object)element2, (Object)oDPackage.getStyle(oDPackage.getDocument("content.xml"), styleDesc, (String)object));
        String string = new Paragraph((Element)((XPath)object3).selectSingleNode(oDPackage.getContent().getDocument())).getStyleName();
        ODSingleXMLDocumentTest.assertNotNull((Object)string);
        ODSingleXMLDocumentTest.assertFalse((boolean)((String)object).equals(string));
        oDPackage = this.createPackage();
        object4 = (Element)oDPackage.getContent().getXPath("//text:h[string() = 'Titre 2']").selectSingleNode(oDPackage.getContent().getDocument());
        object3 = ((Element)object4).getAttributeValue("style-name", ((Element)object4).getNamespace());
        ODSingleXMLDocumentTest.assertNull((Object)oDPackage.getContent().getStyle(styleDesc, (String)object3));
        this.testStyleElem(oDPackage.getXMLFile("styles.xml").getStyle(styleDesc, (String)object3));
        this.testStyleElem(oDPackage.getStyle(styleDesc, (String)object3));
        oDPackage.toSingle();
        this.testStyleElem(oDPackage.getContent().getStyle(styleDesc, (String)object3));
        this.testStyleElem(oDPackage.getStyle(styleDesc, (String)object3));
    }

    private void testStyleElem(Element element) {
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        if (this.version != XMLVersion.OOo) {
            ODSingleXMLDocumentTest.assertEquals((String)"2", (String)element.getAttributeValue("default-outline-level", element.getNamespace()));
        }
        ODSingleXMLDocumentTest.assertEquals((String)"Heading", (String)element.getAttributeValue("parent-style-name", element.getNamespace()));
    }

    public void testMeta() throws Exception {
        ODPackage oDPackage = this.createPackage();
        ODMeta oDMeta = oDPackage.getMeta();
        ODSingleXMLDocumentTest.assertEquals((Object)"firstInfo", (Object)oDMeta.getUserMeta("Info 1").getValue());
        ODSingleXMLDocumentTest.assertEquals((Object)"", (Object)oDMeta.getUserMeta("secondName").getValue());
        List<String> list = Arrays.asList("Info 1", "secondName", "Info 3", "Info 4");
        ODSingleXMLDocumentTest.assertEquals(list, oDMeta.getUserMetaNames());
        ODSingleXMLDocumentTest.assertNull((Object)oDMeta.getUserMeta("toto"));
        ODSingleXMLDocumentTest.assertNotNull((Object)oDMeta.getUserMeta("toto", true));
        oDMeta.removeUserMeta("toto");
        ODSingleXMLDocumentTest.assertNull((Object)oDMeta.getUserMeta("toto"));
        ODUserDefinedMeta oDUserDefinedMeta = oDMeta.getUserMeta("toto", true);
        oDUserDefinedMeta.setValue(3.5);
        ODSingleXMLDocumentTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)oDUserDefinedMeta.getValueType()));
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(3.5f), (Object)Float.valueOf(((BigDecimal)oDUserDefinedMeta.getValue()).floatValue()));
        TimeZone timeZone = TimeZone.getTimeZone("Pacific/Marquesas");
        TimeZone timeZone2 = TimeZone.getTimeZone("PST");
        Calendar calendar = Calendar.getInstance(timeZone2);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        oDUserDefinedMeta.setValue(calendar, ODValueType.TIME);
        Calendar calendar2 = (Calendar)oDUserDefinedMeta.getValue();
        ODSingleXMLDocumentTest.assertEquals((int)n, (int)calendar2.get(11));
        ODSingleXMLDocumentTest.assertEquals((int)n2, (int)calendar2.get(12));
        calendar.setTimeZone(timeZone);
        oDUserDefinedMeta.setValue(calendar, ODValueType.TIME);
        calendar2 = (Calendar)oDUserDefinedMeta.getValue();
        ODSingleXMLDocumentTest.assertFalse((n == calendar2.get(11) ? 1 : 0) != 0);
        ODSingleXMLDocumentTest.assertFalse((n2 == calendar2.get(12) ? 1 : 0) != 0);
        calendar.setTimeZone(timeZone2);
        oDUserDefinedMeta.setValue(calendar, ODValueType.DATE);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)oDUserDefinedMeta.getValue());
        calendar.setTimeZone(timeZone);
        oDUserDefinedMeta.setValue(calendar, ODValueType.DATE);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)oDUserDefinedMeta.getValue());
    }
}

