/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.Manifest;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.StreamUtils;
import org.jopendocument.util.StringInputStream;
import org.jopendocument.util.Zip;
import org.jopendocument.util.ZippedFilesProcessor;

public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    static final Charset MIMETYPE_ENC = Charset.forName("UTF-8");
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private ContentTypeVersioned type = null;
    private File file = null;

    public static final boolean isStandardFile(String string) {
        return string.equals("mimetype") || subdocNames.contains(string) || string.startsWith("Thumbnails") || string.startsWith("META-INF") || string.startsWith("Configurations");
    }

    public ODPackage() {
    }

    public ODPackage(InputStream inputStream) throws IOException {
        this();
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            @Override
            protected void processEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException {
                Object object;
                String string = zipEntry.getName();
                if (subdocNames.contains(string)) {
                    try {
                        object = new ODXMLDocument(OOUtils.getBuilder().build(inputStream));
                    }
                    catch (JDOMException jDOMException) {
                        throw new IllegalStateException("parse error", jDOMException);
                    }
                } else {
                    byteArrayOutputStream.reset();
                    StreamUtils.copy(inputStream, byteArrayOutputStream);
                    object = byteArrayOutputStream.toByteArray();
                }
                ODPackage.this.putFile(string, object, null, zipEntry.getMethod() == 8);
            }
        }.process(inputStream);
        ODPackageEntry oDPackageEntry = this.files.remove("META-INF/manifest.xml");
        if (oDPackageEntry != null) {
            byte[] byArray = (byte[])oDPackageEntry.getData();
            try {
                Map<String, String> map = Manifest.parse(new ByteArrayInputStream(byArray));
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    ODPackageEntry oDPackageEntry2 = this.files.get(string);
                    if (oDPackageEntry2 == null) {
                        this.files.put(string, new ODPackageEntry(string, entry.getValue(), null));
                        continue;
                    }
                    oDPackageEntry2.setType(entry.getValue());
                }
            }
            catch (JDOMException jDOMException) {
                throw new IllegalArgumentException("bad manifest " + new String(byArray), jDOMException);
            }
        }
    }

    public ODPackage(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file), 524288));
        this.file = file;
    }

    public ODPackage(ODPackage oDPackage) {
        this();
        for (String string : oDPackage.getEntries()) {
            ODPackageEntry oDPackageEntry = oDPackage.getEntry(string);
            Object object = oDPackageEntry.getData();
            Object object2 = object instanceof byte[] ? object : (object instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)object, this) : CopyUtils.copy(object));
            this.putFile(string, object2, oDPackageEntry.getType(), oDPackageEntry.isCompressed());
        }
        this.type = oDPackage.type;
        this.file = oDPackage.file;
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File file) {
        this.file = this.addExt(file);
    }

    private final File addExt(File file) {
        String string = '.' + this.getContentType().getExtension();
        if (!file.getName().endsWith(string)) {
            file = new File(file.getParentFile(), file.getName() + string);
        }
        return file;
    }

    public final XMLVersion getVersion() {
        ODXMLDocument oDXMLDocument = this.getContent();
        if (oDXMLDocument == null) {
            return null;
        }
        return oDXMLDocument.getVersion();
    }

    public final ContentTypeVersioned getContentType() {
        if (this.type == null) {
            if (this.files.containsKey("mimetype")) {
                this.type = ContentTypeVersioned.fromMime(new String(this.getBinaryFile("mimetype"), MIMETYPE_ENC));
            } else if (this.getVersion().equals((Object)XMLVersion.OOo)) {
                Element element = this.getContent().getDocument().getRootElement();
                String string = element.getAttributeValue("class", element.getNamespace("office"));
                this.type = ContentTypeVersioned.fromClass(string);
            } else if (this.getVersion().equals((Object)XMLVersion.OD)) {
                Element element = (Element)this.getContent().getChild("body").getChildren().get(0);
                this.type = ContentTypeVersioned.fromBody(element.getName());
            }
        }
        return this.type;
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    public final Map<String, String> validateSubDocuments() {
        OOXML oOXML = OOXML.get(this.getVersion());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : subdocNames) {
            String string2;
            if (!this.getEntries().contains(string) || (string2 = oOXML.getValidator(this.getDocument(string)).isValid()) == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String string) {
        return this.files.get(string);
    }

    protected final Object getData(String string) {
        ODPackageEntry oDPackageEntry = this.getEntry(string);
        return oDPackageEntry == null ? null : oDPackageEntry.getData();
    }

    public final byte[] getBinaryFile(String string) {
        return (byte[])this.getData(string);
    }

    public final ODXMLDocument getXMLFile(String string) {
        return (ODXMLDocument)this.getData(string);
    }

    public final ODXMLDocument getXMLFile(Document document) {
        for (String string : subdocNames) {
            ODXMLDocument oDXMLDocument = this.getXMLFile(string);
            if (oDXMLDocument == null || oDXMLDocument.getDocument() != document) continue;
            return oDXMLDocument;
        }
        return null;
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile(RootElement.CONTENT.getZipEntry());
    }

    public final ODMeta getMeta() {
        ODMeta oDMeta = this.getEntries().contains(RootElement.META.getZipEntry()) ? ODMeta.create(this.getXMLFile(RootElement.META.getZipEntry())) : ODMeta.create(this.getContent());
        return oDMeta;
    }

    public Document getDocument(String string) {
        ODXMLDocument oDXMLDocument = this.getXMLFile(string);
        return oDXMLDocument == null ? null : oDXMLDocument.getDocument();
    }

    public final Element getStyle(StyleDesc<?> styleDesc, String string) {
        return this.getStyle(this.getContent().getDocument(), styleDesc, string);
    }

    /*
     * WARNING - void declaration
     */
    public final Element getStyle(Document document, StyleDesc<?> styleDesc, String string) {
        void var6_9;
        String[] stringArray;
        if (string == null) {
            return null;
        }
        String string2 = null;
        for (String string3 : stringArray = new String[]{RootElement.CONTENT.getZipEntry(), RootElement.STYLES.getZipEntry()}) {
            if (this.getDocument(string3) != document) continue;
            string2 = string3;
        }
        if (string2 == null) {
            throw new IllegalArgumentException("neither in content nor styles : " + document);
        }
        Element element = this.getXMLFile(string2).getStyle(styleDesc, string);
        if (element == null && string2.equals(stringArray[0]) && this.getXMLFile(stringArray[1]) != null) {
            Element element2 = this.getXMLFile(stringArray[1]).getStyle(styleDesc, string);
        }
        return var6_9;
    }

    public void putFile(String string, Object object) {
        this.putFile(string, object, null);
    }

    public void putFile(String string, Object object, String string2) {
        this.putFile(string, object, string2, true);
    }

    public void putFile(String string, Object object, String string2, boolean bl) {
        Object object2;
        Object object3;
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (subdocNames.contains(string)) {
            object3 = object instanceof Document ? new ODXMLDocument((Document)object) : (ODXMLDocument)object;
            if (this.getVersion() != null && !((ODXMLDocument)object3).getVersion().equals((Object)this.getVersion())) {
                throw new IllegalArgumentException("version mismatch " + (Object)((Object)this.getVersion()) + " != " + object3);
            }
            object2 = object3;
        } else {
            if (object != null && !(object instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + string + ": " + object);
            }
            object2 = object;
        }
        object3 = string2 != null ? string2 : FileUtils.findMimeType(string);
        this.files.put(string, new ODPackageEntry(string, (String)object3, object2, bl));
    }

    public void rmFile(String string) {
        this.files.remove(string);
    }

    public ODSingleXMLDocument toSingle() {
        if (!this.isSingle()) {
            Document document = this.removeAndGetDoc(RootElement.CONTENT.getZipEntry());
            Document document2 = this.removeAndGetDoc(RootElement.STYLES.getZipEntry());
            Document document3 = this.removeAndGetDoc(RootElement.SETTINGS.getZipEntry());
            Document document4 = this.removeAndGetDoc(RootElement.META.getZipEntry());
            return ODSingleXMLDocument.createFromDocument(document, document2, document3, document4, this);
        }
        return (ODSingleXMLDocument)this.getContent();
    }

    public final boolean isSingle() {
        return this.getContent() instanceof ODSingleXMLDocument;
    }

    private Document removeAndGetDoc(String string) {
        if (!this.files.containsKey(string)) {
            return null;
        }
        ODXMLDocument oDXMLDocument = (ODXMLDocument)this.files.remove(string).getData();
        return oDXMLDocument == null ? null : oDXMLDocument.getDocument();
    }

    public final boolean split() {
        boolean bl;
        if (this.isSingle()) {
            Map<RootElement, Document> map = ((ODSingleXMLDocument)this.getContent()).split();
            assert ((map.containsKey((Object)RootElement.CONTENT) || map.containsKey((Object)RootElement.STYLES)) && RootElement.getPackageElements().containsAll(map.keySet())) : "wrong elements " + map;
            XMLVersion xMLVersion = this.getVersion();
            for (Map.Entry<RootElement, Document> entry : map.entrySet()) {
                this.putFile(entry.getKey().getZipEntry(), new ODXMLDocument(entry.getValue(), xMLVersion));
            }
            bl = true;
        } else {
            bl = false;
        }
        assert (!this.isSingle());
        return bl;
    }

    public final void save(OutputStream outputStream) throws IOException {
        if (this.isSingle()) {
            assert (this.getClass() == ODPackage.class);
            ODPackage oDPackage = new ODPackage(this);
            oDPackage.split();
            oDPackage.save(outputStream);
            return;
        }
        Zip zip = new Zip(outputStream);
        zip.zipNonCompressed("mimetype", this.getMimeType().getBytes(MIMETYPE_ENC));
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String string : this.files.keySet()) {
            Object object;
            if (string.equals("mimetype") || string.equals("META-INF/manifest.xml")) continue;
            ODPackageEntry oDPackageEntry = this.files.get(string);
            Object object2 = oDPackageEntry.getData();
            if (object2 != null) {
                if (object2 instanceof ODXMLDocument) {
                    object = zip.createEntry(string);
                    OUTPUTTER.output(((ODXMLDocument)object2).getDocument(), (OutputStream)object);
                    ((OutputStream)object).close();
                } else {
                    zip.zip(string, (byte[])object2, oDPackageEntry.isCompressed());
                }
            }
            manifest.addEntry(string, (String)((object = oDPackageEntry.getType()) == null ? "" : object));
        }
        zip.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        zip.close();
    }

    public File save() throws IOException {
        return this.saveAs(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAs(File file) throws IOException {
        File file2 = this.addExt(file);
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 524288);
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
        return file2;
    }

    static {
        for (RootElement rootElement : RootElement.getPackageElements()) {
            if (rootElement.getZipEntry() == null) continue;
            subdocNames.add(rootElement.getZipEntry());
        }
    }

    public static enum RootElement {
        SINGLE_CONTENT("office", "document", null),
        CONTENT("office", "document-content", "content.xml"),
        STYLES("office", "document-styles", "styles.xml"),
        META("office", "document-meta", "meta.xml"),
        SETTINGS("office", "document-settings", "settings.xml");

        private final String nsPrefix;
        private final String name;
        private final String zipEntry;

        public static final EnumSet<RootElement> getPackageElements() {
            return EnumSet.of(CONTENT, STYLES, META, SETTINGS);
        }

        public static final RootElement fromElementName(String string) {
            for (RootElement rootElement : RootElement.values()) {
                if (!rootElement.getElementName().equals(string)) continue;
                return rootElement;
            }
            return null;
        }

        static final Document createSingle(Document document) {
            XMLVersion xMLVersion = XMLVersion.getVersion(document);
            return SINGLE_CONTENT.createDocument(xMLVersion, document.getRootElement().getAttributeValue("version", xMLVersion.getOFFICE()));
        }

        private RootElement(String string2, String string3, String string4) {
            this.nsPrefix = string2;
            this.name = string3;
            this.zipEntry = string4;
        }

        public final String getElementNSPrefix() {
            return this.nsPrefix;
        }

        public final String getElementName() {
            return this.name;
        }

        public final Document createDocument(XMLVersion xMLVersion, String string) {
            Element element = new Element(this.getElementName(), xMLVersion.getNS(this.getElementNSPrefix()));
            if (string != null) {
                element.setAttribute("version", string, xMLVersion.getOFFICE());
            }
            for (Namespace namespace : xMLVersion.getALL()) {
                element.addNamespaceDeclaration(namespace);
            }
            Document document = new Document(element);
            if (xMLVersion == XMLVersion.OOo) {
                document.setDocType(new DocType(this.getElementNSPrefix() + ":" + this.getElementName(), "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", "office.dtd"));
            }
            return document;
        }

        public final String getZipEntry() {
            return this.zipEntry;
        }
    }
}

