/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.util.Tuple2;

public class LengthUnitTest
extends TestCase {
    public void testParseLength() throws Exception {
        LengthUnitTest.assertEquals(Tuple2.create(new BigDecimal("15.2"), LengthUnit.CM), LengthUnit.parseLength("15.2cm"));
        this.testPositiveLength("-15.2cm", true);
        this.testPositiveLength("-15.2cm", false);
        this.testPositiveLength("-0cm", true);
        this.testPositiveLength("0cm", true);
        LengthUnitTest.assertEquals((Object)BigDecimal.ZERO, (Object)LengthUnit.parsePositiveLength("0cm", LengthUnit.MM, false).stripTrailingZeros());
        LengthUnitTest.assertEquals((int)BigDecimal.ZERO.compareTo(LengthUnit.parsePositiveLength("0cm", LengthUnit.INCH, false)), (int)0);
        LengthUnitTest.assertEquals((int)new BigDecimal("152").compareTo(LengthUnit.parsePositiveLength("15.2cm", LengthUnit.MM, true)), (int)0);
        LengthUnitTest.assertEquals((Object)new BigDecimal("152"), (Object)LengthUnit.parseLength("15.2cm", LengthUnit.MM).stripTrailingZeros());
        LengthUnitTest.assertEquals((Object)new BigDecimal("1.52"), (Object)LengthUnit.parseLength("15.2mm", LengthUnit.CM).stripTrailingZeros());
        LengthUnitTest.assertEquals((Object)new BigDecimal("2.54"), (Object)LengthUnit.parseLength("1in", LengthUnit.CM).stripTrailingZeros());
        LengthUnitTest.assertEquals((Object)new BigDecimal("1"), (Object)LengthUnit.parseLength("72pt", LengthUnit.INCH).stripTrailingZeros());
        LengthUnitTest.assertEquals((Object)new BigDecimal("2"), (Object)LengthUnit.parseLength("12pc", LengthUnit.INCH).stripTrailingZeros());
    }

    private void testPositiveLength(String string, boolean bl) {
        try {
            LengthUnit.parsePositiveLength(string, LengthUnit.CM, bl);
            LengthUnitTest.fail((String)"A length is positive");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

