/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jopendocument.util.DecimalUtils;
import org.jopendocument.util.Tuple2;

public enum LengthUnit {
    MM("mm", BigDecimal.ONE),
    CM("cm", BigDecimal.TEN),
    INCH("in", new BigDecimal("25.4")),
    POINT("pt", LengthUnit.INCH.multiplier.divide(new BigDecimal(72), DecimalUtils.HIGH_PRECISION)),
    PICA("pc", LengthUnit.INCH.multiplier.divide(new BigDecimal(6), DecimalUtils.HIGH_PRECISION));

    private final String symbol;
    private final BigDecimal multiplier;
    private static final Pattern lenghPattern;

    private LengthUnit(String string2, BigDecimal bigDecimal) {
        this.symbol = string2;
        this.multiplier = bigDecimal;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final BigDecimal convertTo(BigDecimal bigDecimal, LengthUnit lengthUnit) {
        if (this == lengthUnit) {
            return bigDecimal;
        }
        return bigDecimal.multiply(this.multiplier).divide(lengthUnit.multiplier, DecimalUtils.HIGH_PRECISION);
    }

    public static final LengthUnit fromSymbol(String string) {
        for (LengthUnit lengthUnit : LengthUnit.values()) {
            if (!lengthUnit.symbol.equals(string)) continue;
            return lengthUnit;
        }
        return null;
    }

    private static final String[] parseLength2String(String string) {
        Matcher matcher = lenghPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalStateException("unable to parse " + string);
        }
        return new String[]{matcher.group(1), matcher.group(3)};
    }

    public static final Tuple2<BigDecimal, LengthUnit> parseLength(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = LengthUnit.parseLength2String(string);
        LengthUnit lengthUnit = LengthUnit.fromSymbol(stringArray[1]);
        if (lengthUnit == null) {
            throw new IllegalStateException("unknown unit " + (Object)((Object)lengthUnit));
        }
        return Tuple2.create(new BigDecimal(stringArray[0]), lengthUnit);
    }

    public static final BigDecimal parseLength(String string, LengthUnit lengthUnit) {
        if (string == null) {
            return null;
        }
        Tuple2<BigDecimal, LengthUnit> tuple2 = LengthUnit.parseLength(string);
        return tuple2.get1().convertTo(tuple2.get0(), lengthUnit);
    }

    public static final BigDecimal parsePositiveLength(String string, LengthUnit lengthUnit, boolean bl) {
        BigDecimal bigDecimal = LengthUnit.parseLength(string, lengthUnit);
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException(bigDecimal + " < 0");
        }
        if (bl && bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException(bigDecimal + " == 0");
        }
        return bigDecimal;
    }

    static {
        lenghPattern = Pattern.compile("(-?\\d+(\\.\\d+)?)(\\p{Alpha}+)?");
    }
}

