/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextStyle;

public class GraphicStyle
extends StyleStyle {
    public static final StyleStyleDesc<GraphicStyle> DESC = new StyleStyleDesc<GraphicStyle>(GraphicStyle.class, XMLVersion.OD, "graphic", "fr", "draw", Arrays.asList("dr3d:cube", "dr3d:extrude", "dr3d:rotate", "dr3d:scene", "dr3d:sphere", "draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:custom-shape", "draw:ellipse", "draw:frame", "draw:g", "draw:line", "draw:measure", "draw:page-thumbnail", "draw:path", "draw:polygon", "draw:polyline", "draw:rect", "draw:regular-polygon", "office:annotation")){

        @Override
        public GraphicStyle create(ODPackage oDPackage, Element element) {
            return new GraphicStyle(oDPackage, element);
        }
    };
    public static final StyleStyleDesc<GraphicStyle> DESC_OO = new StyleStyleDesc<GraphicStyle>(GraphicStyle.class, XMLVersion.OOo, "graphics", "fr", "draw", Arrays.asList("draw:text-box", "draw:image", "draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:ellipse", "draw:line", "draw:measure", "draw:page-thumbnail", "draw:path", "draw:polygon", "draw:polyline", "draw:rect")){

        @Override
        public GraphicStyle create(ODPackage oDPackage, Element element) {
            return new GraphicStyle(oDPackage, element);
        }
    };
    private TextStyle.StyleTextProperties textProps = null;
    private ParagraphStyle.StyleParagraphProperties pProps = null;
    private StyleGraphicProperties graphProps = null;

    public GraphicStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.StyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.StyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public final StyleGraphicProperties getGraphicProperties() {
        if (this.graphProps == null) {
            this.graphProps = new StyleGraphicProperties(this);
        }
        return this.graphProps;
    }

    public static class StyleGraphicProperties
    extends StyleProperties {
        private static Pattern split = Pattern.compile(" ");

        public StyleGraphicProperties(StyleStyle styleStyle) {
            super(styleStyle, DESC.getFamily());
        }

        public final String getHorizontalPosition() {
            return this.getElement().getAttributeValue("horizontal-pos", this.getElement().getNamespace("style"));
        }

        public final String getHorizontalRelation() {
            return this.getElement().getAttributeValue("horizontal-rel", this.getElement().getNamespace("style"));
        }

        public final String getVerticalPosition() {
            return this.getElement().getAttributeValue("vertical-pos", this.getElement().getNamespace("style"));
        }

        public final String getVerticalRelation() {
            return this.getElement().getAttributeValue("vertical-rel", this.getElement().getNamespace("style"));
        }

        public final List<String> getProtected() {
            String string = this.getElement().getAttributeValue("protect", this.getElement().getNamespace("style"));
            if (string == null || "none".equals(string)) {
                return Collections.emptyList();
            }
            return Arrays.asList(split.split(string));
        }

        public final boolean isContentPrinted() {
            return this.parseBoolean(this.getElement().getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }
    }
}

