/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.sample.model;

import java.util.ArrayList;
import java.util.List;
import org.jopenchart.DataModel1D;
import org.jopenchart.DataModelListener;

public class DataModel1DMorphing
extends DataModel1D
implements DataModelListener {
    private static final int STEP = 5;
    DataModel1D src;
    int count = 50;
    final List<Double> dy;
    private Number initialValue;

    public DataModel1DMorphing(final DataModel1D src, final Number initialValue) {
        this.src = src;
        this.initialValue = initialValue;
        this.src.addDataModelListener(this);
        final int size = src.getSize();
        this.dy = new ArrayList<Double>(size);
        int i = 0;
        while (i < size) {
            this.dy.add(null);
            ++i;
        }
        this.computeDy();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    int i = 0;
                    while (i < DataModel1DMorphing.this.count) {
                        Number minValue = initialValue;
                        if (initialValue == null) {
                            minValue = src.getMinValue();
                        }
                        int j = 0;
                        while (j < size) {
                            Number srcValue = src.getValueAt(j);
                            if (srcValue != null) {
                                Number current = DataModel1DMorphing.this.getValueAt(j);
                                if (current == null) {
                                    DataModel1DMorphing.this.setValueAt(j, minValue);
                                } else if (DataModel1DMorphing.this.dy.get(j) != null) {
                                    double currentDy = DataModel1DMorphing.this.dy.get(j);
                                    double newValue = current.doubleValue() + currentDy;
                                    DataModel1DMorphing.this.setValueAt(j, new Double(newValue));
                                    current = DataModel1DMorphing.this.getValueAt(j);
                                    if (newValue > srcValue.doubleValue()) {
                                        DataModel1DMorphing.this.setValueAt(j, srcValue);
                                        DataModel1DMorphing.this.dy.set(j, null);
                                    }
                                }
                            }
                            ++j;
                        }
                        try {
                            Thread.sleep(5L, 0);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        DataModel1DMorphing.this.fireDataModelChanged();
                        ++i;
                    }
                    DataModel1D dataModel1D = DataModel1DMorphing.this.src;
                    synchronized (dataModel1D) {
                        try {
                            src.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        t.setPriority(1);
        t.start();
    }

    @Override
    public int getSize() {
        return this.src.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataChanged() {
        this.computeDy();
        this.count += 5;
        DataModel1D dataModel1D = this.src;
        synchronized (dataModel1D) {
            this.src.notifyAll();
        }
    }

    private void computeDy() {
        int j = 0;
        while (j < this.getSize()) {
            Number v = this.src.getValueAt(j);
            if (v != null) {
                double currentDy = v.doubleValue() / 5.0;
                this.dy.set(j, new Double(currentDy));
            }
            ++j;
        }
    }

    @Override
    public Number getMinValue() {
        if (this.initialValue == null) {
            return super.getMinValue();
        }
        return this.initialValue;
    }
}

