/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.sample.devguide;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jopenchart.Chart;
import org.jopenchart.ChartPanel;
import org.jopenchart.URLParser;
import org.jopenchart.sample.devguide.URLPanel;

public class GuidePanel
extends JPanel {
    GuidePanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public void addURL(String url) {
        JPanel panel = this.createPanel(url);
        this.add(panel);
    }

    private JPanel createPanel(String url) {
        JPanel p = new JPanel();
        p.setBackground(Color.WHITE);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 1;
        JTextArea textAreaUrl = new JTextArea("Google API URL: " + url.replaceAll("&", "\n&"));
        textAreaUrl.setLineWrap(true);
        p.add((Component)textAreaUrl, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.fill = 1;
        c.weightx = 1.0;
        JTextArea textCode = new JTextArea();
        textCode.setMinimumSize(new Dimension(300, 300));
        textCode.setPreferredSize(new Dimension(300, 300));
        textCode.setText("Source Code");
        p.add((Component)new JScrollPane(textCode), c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        c.gridheight = 1;
        URLParser parser = new URLParser(url);
        Chart chart = parser.getChart();
        if (chart != null) {
            ChartPanel panel = new ChartPanel(chart);
            p.add((Component)panel, c);
            ++c.gridy;
            URLPanel uPanle = new URLPanel(url);
            uPanle.setPreferredSize(chart.getDimension());
            uPanle.setMinimumSize(chart.getDimension());
            p.add((Component)uPanle, c);
        }
        return p;
    }

    public void addTitle(String string) {
        JLabel label = new JLabel(string);
        label.setFont(label.getFont().deriveFont(1));
        this.add(label);
    }
}

