/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.piechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import org.jopenchart.Chart;
import org.jopenchart.DataModel1D;
import org.jopenchart.Label;

public class PieChart
extends Chart {
    private final List<Label> labels = new ArrayList<Label>();
    private Color separatorColor = Color.WHITE;
    private int innerWidth;
    private int innerHeight;
    private Color innerColor;

    public void setData(List<Number> data) {
        DataModel1D m = new DataModel1D();
        m.addAll(data);
        this.setDataModel(m);
    }

    public void setDataModel(DataModel1D m) {
        this.model = m;
    }

    @Override
    public void setDimension(Dimension dimension) {
        super.setDimension(dimension);
        this.setChartRectangle(new Rectangle(0, 0, dimension.width, dimension.height));
    }

    @Override
    public void renderPlot(Graphics2D g) {
        int angle;
        Number n;
        int height2;
        g.setColor(Color.RED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int xCenter = this.getCenterX();
        int yCenter = this.getCenterY();
        DataModel1D model1 = (DataModel1D)this.getDataModel();
        double total = this.getTotalValue().doubleValue();
        double space = 0.0;
        int stop = model1.getSize();
        Color[] colors = new Color[stop];
        double[] spaces = new double[stop];
        Color origine = this.getColor(0);
        double mR = origine.getRed();
        double mV = origine.getGreen();
        double mB = origine.getBlue();
        double dR = (255.0 - (double)origine.getRed()) / (double)stop;
        double dV = (255.0 - (double)origine.getGreen()) / (double)stop;
        double dB = (255.0 - (double)origine.getBlue()) / (double)stop;
        int i = 0;
        while (i < stop) {
            colors[i] = new Color((int)mR, (int)mV, (int)mB);
            mR += dR;
            mV += dV;
            mB += dB;
            spaces[i] = space;
            ++i;
        }
        int maxSpace = (int)spaces[0];
        int width2 = height2 = Math.min(xCenter, yCenter) - maxSpace - this.getMaxLabelHeight(g) / 2 - 2;
        int posX = this.getCenterX() - width2;
        int posY = this.getCenterY() - width2;
        double ratio = 360.0 / total;
        double startAngle = 0.0;
        int i2 = 0;
        while (i2 < stop) {
            n = model1.getValueAt(i2);
            if (n != null) {
                angle = (int)Math.round(n.doubleValue() * ratio);
                double moveAngle = startAngle - (double)angle / 2.0;
                double angleRadian = moveAngle * Math.PI * 2.0 / 360.0;
                double current_space = spaces[i2];
                int x = posX + width2 / 2 + (int)(Math.cos(angleRadian) * current_space);
                int y = posY + height2 / 2 + (int)(-Math.sin(angleRadian) * current_space);
                g.setColor(colors[i2]);
                g.setStroke(new BasicStroke(width2 - this.innerWidth, 0, 0, 12.0f, null, 10.0f));
                g.drawArc(x, y, width2, height2, (int)Math.round(startAngle), -angle);
                g.setStroke(new BasicStroke());
                if (i2 < this.labels.size()) {
                    int xLabel;
                    int x3;
                    String label = this.labels.get(i2).getLabel();
                    int x1 = width2 + posX + (int)Math.round(Math.cos(angleRadian) * ((double)width2 + current_space));
                    int y1 = height2 + posY + (int)Math.round(-Math.sin(angleRadian) * ((double)height2 + current_space));
                    int x2 = width2 + posX + (int)Math.round(Math.cos(angleRadian) * ((double)width2 + current_space + 3.0));
                    int y2 = height2 + posY + (int)Math.round(-Math.sin(angleRadian) * ((double)height2 + current_space + 3.0));
                    g.setColor(Color.GRAY);
                    g.drawLine(x1, y1, x2, y2);
                    int y4 = y2 + g.getFontMetrics().getAscent() / 2 - 2;
                    if (x1 > xCenter) {
                        x3 = x2 + 2 + (this.getChartRectangle().width - x1) / 2;
                        xLabel = x3 + 2;
                        if ((double)(x3 + this.getLabelWidth(g, label)) > this.getChartRectangle().getWidth()) {
                            x3 = (int)this.getChartRectangle().getWidth() - this.getLabelWidth(g, label) - 4;
                            xLabel = x3 + 4;
                        }
                    } else {
                        x3 = x2;
                        x2 = (xCenter - width2) / 2;
                        xLabel = x2 - this.getMaxLabelWidth(g) - 2;
                        if (xLabel < 0) {
                            xLabel = 0;
                            x2 = this.getLabelWidth(g, label);
                        }
                    }
                    if (x2 < x3) {
                        g.drawLine(x2, y2, x3, y2);
                    }
                    g.drawString(label, xLabel, y4);
                }
                startAngle -= (double)angle;
            }
            ++i2;
        }
        if (this.getSeparatorColor() != null) {
            startAngle = 0.0;
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(this.getSeparatorColor());
            i2 = 0;
            while (i2 < stop) {
                n = model1.getValueAt(i2);
                if (n != null) {
                    angle = (int)Math.round(n.doubleValue() * ratio);
                    double angleRadian = startAngle * Math.PI * 2.0 / 360.0;
                    double current_space = spaces[i2];
                    int x2 = posX + width2 + (int)(Math.cos(angleRadian) * ((double)width2 + current_space + 2.0));
                    int y2 = posY + height2 + (int)(-Math.sin(angleRadian) * ((double)height2 + current_space + 2.0));
                    g.drawLine(xCenter, yCenter, x2, y2);
                    startAngle -= (double)angle;
                }
                ++i2;
            }
        }
    }

    private int getLabelWidth(Graphics2D g, String label) {
        int w = (int)g.getFontMetrics().getStringBounds(label, g).getWidth();
        return w;
    }

    private Number getTotalValue() {
        DataModel1D model1 = (DataModel1D)this.getDataModel();
        double total = 0.0;
        int i = 0;
        while (i < model1.getSize()) {
            Number n = model1.getValueAt(i);
            if (n != null) {
                total += n.doubleValue();
            }
            ++i;
        }
        return total;
    }

    private int getCenterY() {
        return this.getChartRectangle().height / 2;
    }

    private int getCenterX() {
        return this.getChartRectangle().width / 2;
    }

    private void renderInner(Graphics2D g, int width2, int height2, double[] spaces) {
        double startAngle = 0.0;
        DataModel1D model1 = (DataModel1D)this.getDataModel();
        int stop = model1.getSize();
        g.setColor(this.innerColor);
        double ratio = 360.0 / this.getTotalValue().doubleValue();
        int posX = this.getCenterX() - this.innerWidth / 2;
        int posY = this.getCenterY() - this.innerHeight / 2;
        int i = 0;
        while (i < stop) {
            Number n = model1.getValueAt(i);
            if (n != null) {
                int angle = (int)Math.round(n.doubleValue() * ratio);
                double moveAngle = startAngle - (double)angle / 2.0;
                double angleRadian = moveAngle * Math.PI * 2.0 / 360.0;
                double current_space = spaces[i];
                int x = posX + (int)(Math.cos(angleRadian) * current_space);
                int y = posY + (int)(-Math.sin(angleRadian) * current_space);
                g.fillArc(x, y, this.innerWidth, this.innerHeight, (int)Math.round(startAngle) + 50, -angle - 100);
                startAngle -= (double)angle;
            }
            ++i;
        }
    }

    public Color getInnerColor() {
        return this.innerColor;
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    private int getMaxLabelHeight(Graphics2D g) {
        int max = 0;
        for (Label label : this.labels) {
            int w = (int)g.getFontMetrics().getStringBounds(label.getLabel(), g).getHeight();
            if (w <= max) continue;
            max = w;
        }
        return max;
    }

    public int getMaxLabelWidth(Graphics2D g) {
        int max = 0;
        for (Label label : this.labels) {
            int w = (int)g.getFontMetrics().getStringBounds(label.getLabel(), g).getWidth();
            if (w <= max) continue;
            max = w;
        }
        return max;
    }

    public void addLabel(Label label) {
        this.labels.add(label);
    }

    public void setInnerDimension(int width, int height) {
        this.innerWidth = width;
        this.innerHeight = height;
    }

    public void setInnerColor(Color color) {
        this.innerColor = color;
    }
}

