/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.linechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.jopenchart.ArrayOfInt;
import org.jopenchart.Axis;
import org.jopenchart.BottomAxis;
import org.jopenchart.Chart;
import org.jopenchart.DataModel1D;
import org.jopenchart.DataModelMultiple;
import org.jopenchart.LeftAxis;
import org.jopenchart.marker.ShapeMarker;

public class LineChart
extends Chart {
    private Number lowerRange;
    private Number higherRange;
    private Color fillColor;
    private Double gridXStep;
    private Double gridYStep;
    private Stroke gridStroke;
    private Color gridColor = Color.LIGHT_GRAY;
    private List<Stroke> lineStrokes = new ArrayList<Stroke>();
    private List<ShapeMarker> markers = new ArrayList<ShapeMarker>();

    public LineChart() {
        this.left = new LeftAxis();
        this.bottom = new BottomAxis();
        this.gridStroke = new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
    }

    public Stroke getStroke(int index) {
        if (index >= this.lineStrokes.size()) {
            return new BasicStroke(1.6f, 1, 1);
        }
        return this.lineStrokes.get(index);
    }

    @Override
    public DataModelMultiple getDataModel() {
        return (DataModelMultiple)this.model;
    }

    public void setDataModel(DataModelMultiple m) {
        this.model = m;
    }

    public void setDataModel(DataModel1D m) {
        this.model = new DataModelMultiple();
        this.getDataModel().addModel(m);
    }

    public void setLowerRange(Number n) {
        this.lowerRange = n;
    }

    public void setHigherRange(Number n) {
        this.higherRange = n;
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
    }

    public Number getLowerRange() {
        if (this.lowerRange == null) {
            return this.getDataModel().getMinValue();
        }
        return this.lowerRange;
    }

    public Number getHigherRange() {
        if (this.higherRange == null) {
            return this.getDataModel().getMaxValue();
        }
        return this.higherRange;
    }

    public void setData(List<Number> data) {
        DataModel1D m = new DataModel1D();
        m.addAll(data);
        this.setDataModel(m);
    }

    public void setLeftAxis(Axis axis) {
        this.left = new LeftAxis(axis);
    }

    public void setBottomAxis(Axis axis) {
        this.bottom = new BottomAxis(axis);
    }

    @Override
    public void prepareRendering(Graphics2D g) {
        int leftWidth = 1 + this.left.getMaxLabelWidth(g) + this.left.getMarkerLenght() + this.left.getMarkerSpacing();
        int rightWidth = this.bottom.getMaxLabelWidth(g) / 2;
        int topHeight = this.left.getMaxLabelHeight(g) / 2;
        int bottomHeight = 1 + this.bottom.getMaxLabelHeight(g) + this.bottom.getMarkerLenght() + this.bottom.getMarkerSpacing();
        int graphWidth = this.getDimension().width - leftWidth - rightWidth;
        int graphHeight = this.getDimension().height - topHeight - bottomHeight;
        this.left.setX(0);
        this.left.setY(topHeight);
        this.left.setWidth(leftWidth);
        this.left.setHeight(graphHeight);
        this.bottom.setX(leftWidth - 1);
        this.bottom.setY(topHeight + graphHeight);
        this.bottom.setWidth(graphWidth);
        this.bottom.setHeight(bottomHeight);
        this.setChartRectangle(new Rectangle(leftWidth, topHeight, graphWidth, graphHeight));
    }

    @Override
    public void renderPlot(Graphics2D g) {
        this.renderGrid(g);
        DataModelMultiple models = this.getDataModel();
        int index = 0;
        while (index < models.getSize()) {
            DataModel1D model1 = models.getModel(index);
            double maxXValue = this.getHigherRange().doubleValue();
            double minXValue = this.getLowerRange().doubleValue();
            double rangeXValue = maxXValue - minXValue;
            int length = model1.getSize();
            int graphPosX = this.getChartRectangle().x;
            int graphPosY = this.getChartRectangle().y;
            int graphWidth = this.getChartRectangle().width;
            int graphHeight = this.getChartRectangle().height;
            double dx = (double)graphWidth / (double)(length - 1);
            double ratioy = (double)graphHeight / rangeXValue;
            double x1 = graphPosX;
            ArrayOfInt lx = new ArrayOfInt();
            ArrayOfInt ly = new ArrayOfInt();
            Number n2 = null;
            int i = 0;
            while (i < length - 1) {
                Number n1 = model1.getValueAt(i);
                n2 = model1.getValueAt(i + 1);
                if (n1 != null) {
                    int y1 = graphPosY + graphHeight - (int)((n1.doubleValue() - minXValue) * ratioy);
                    lx.add((int)x1);
                    ly.add(y1);
                } else if (n1 == null && n2 != null && !lx.isEmpty()) {
                    g.drawPolyline(lx.getArray(), ly.getArray(), lx.getSize());
                    lx.clear();
                    ly.clear();
                }
                x1 += dx;
                ++i;
            }
            if (n2 != null) {
                int y1 = graphPosY + graphHeight - (int)((n2.doubleValue() - minXValue) * ratioy);
                lx.add((int)x1);
                ly.add(y1);
            }
            int polyLength = lx.getSize();
            if (this.fillColor != null && polyLength > 0) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setStroke(new BasicStroke());
                g.setColor(this.fillColor);
                lx.add(lx.get(polyLength - 1));
                ly.add(graphPosY + graphHeight);
                lx.add(lx.get(0));
                ly.add(graphPosY + graphHeight);
                GradientPaint gp = new GradientPaint(graphPosX + graphWidth, graphPosY, Color.white, graphPosX, graphPosY + graphHeight, new Color(230, 235, 250), false);
                g.setPaint(gp);
                g.fillPolygon(lx.getArray(), ly.getArray(), polyLength + 2);
            }
            if (!lx.isEmpty()) {
                g.setPaint(null);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setStroke(this.getStroke(index));
                g.setColor(this.getColor(index));
                g.drawPolyline(lx.getArray(), ly.getArray(), polyLength);
            }
            ++index;
        }
        this.renderMarkers(g);
    }

    private void renderMarkers(Graphics2D g) {
        for (ShapeMarker marker : this.markers) {
            marker.draw(this, g);
        }
    }

    private void renderGrid(Graphics2D g) {
        int graphPosX = this.getChartRectangle().x - 1;
        int graphPosY = this.getChartRectangle().y + this.getChartRectangle().height;
        g.setColor(this.gridColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(this.gridStroke);
        if (this.gridXStep != null) {
            double gridXStep2 = this.gridXStep * (double)this.getChartRectangle().width / 100.0;
            double x = graphPosX + this.getChartRectangle().width;
            while (x > (double)graphPosX) {
                g.drawLine((int)x, graphPosY, (int)x, this.getChartRectangle().y);
                x -= gridXStep2;
            }
        }
        if (this.gridYStep != null) {
            double gridYStep2 = this.gridYStep * (double)this.getChartRectangle().height / 100.0;
            double y = this.getChartRectangle().y;
            while (y < (double)graphPosY) {
                g.drawLine(graphPosX, (int)y, graphPosX + this.getChartRectangle().width, (int)y);
                y += gridYStep2;
            }
        }
    }

    @Override
    public void renderAxis(Graphics2D g) {
        g.setColor(Color.GRAY);
        g.setStroke(new BasicStroke());
        this.left.render(g);
        this.bottom.render(g);
    }

    public void setGridXStep(Double dx) {
        this.gridXStep = dx;
    }

    public void setGridYStep(Double dy) {
        this.gridYStep = dy;
    }

    public void setGridStroke(Stroke stroke) {
        this.gridStroke = stroke;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setGridSegment(float lineLength, float blankLenght) {
        this.gridStroke = new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{lineLength, blankLenght}, 0.0f);
    }

    public void setMultipleData(List<List<Number>> multipleData) {
        this.setDataModel(new DataModelMultiple(multipleData));
    }

    public void setStrokes(List<Stroke> strokes) {
        this.lineStrokes.clear();
        this.lineStrokes.addAll(strokes);
    }

    public void addMarkers(List<ShapeMarker> markers) {
        this.markers.addAll(markers);
    }
}

