/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.barchart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import org.jopenchart.DataModel1D;
import org.jopenchart.barchart.VerticalBarChart;

public class VerticalStackBarChart
extends VerticalBarChart {
    private Stroke gridStroke;
    private Color gridColor = Color.LIGHT_GRAY;

    public VerticalStackBarChart() {
        this.gridStroke = new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
    }

    @Override
    public void renderPlot(Graphics2D g) {
        int nbBar = this.getBarNumber();
        int graphPosX = this.getChartRectangle().x;
        int graphPosY = this.getChartRectangle().y;
        int graphHeight = this.getChartRectangle().height;
        Number higherRange = this.getHigherRange();
        Number lowerRange = this.getLowerRange();
        if (higherRange == null) {
            higherRange = this.getDataModel().getMaxValue();
        }
        if (lowerRange == null) {
            lowerRange = this.getDataModel().getMinValue();
        }
        double maxXValue = higherRange.doubleValue();
        double minXValue = lowerRange.doubleValue();
        double rangeXValue = maxXValue - minXValue;
        double ratioy = (double)graphHeight / rangeXValue;
        long x = graphPosX + this.getSpaceBetweenBars();
        int i = 0;
        while (i < nbBar) {
            long y = graphPosY + graphHeight;
            int j = 0;
            while (j < this.getModelNumber()) {
                DataModel1D model1 = this.getModel(j);
                Number valueAt = model1.getValueAt(i);
                if (valueAt != null) {
                    double h = valueAt.doubleValue() * ratioy;
                    g.setColor(this.getColor(j));
                    y = (long)((double)y - (Math.ceil(h) - 1.0));
                    g.fillRect((int)x, (int)y, this.getBarWidth(), (int)h);
                }
                ++j;
            }
            x += (long)(this.getSpaceBetweenBars() + this.getBarWidth());
            ++i;
        }
        g.setColor(Color.pink);
        g.drawRect(this.getChartRectangle().x, this.getChartRectangle().y, this.getChartRectangle().width, this.getChartRectangle().height);
    }

    public void setMultipleData(List<List<Number>> multipleData) {
        for (List<Number> list : multipleData) {
            this.addModel(new DataModel1D(list.toArray(new Number[0])));
        }
    }
}

