/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.barchart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import org.jopenchart.DataModel1D;
import org.jopenchart.barchart.GraphIndex;
import org.jopenchart.barchart.VerticalBarChart;

public class VerticalGroupBarChart
extends VerticalBarChart {
    private List<GraphIndex> indexes = new ArrayList<GraphIndex>();
    private GraphIndex highlight;

    @Override
    public void renderPlot(Graphics2D g) {
        Number valueAt;
        int nbBar = this.getBarNumber();
        int graphPosX = this.getChartRectangle().x;
        int graphPosY = this.getChartRectangle().y;
        int graphHeight = this.getChartRectangle().height;
        Number higherRange = this.getHigherRange();
        Number lowerRange = this.getLowerRange();
        if (higherRange == null) {
            higherRange = this.getDataModel().getMaxValue();
        }
        if (lowerRange == null) {
            lowerRange = this.getDataModel().getMinValue();
        }
        double maxYValue = Math.max(0.0, this.getDataModel().getMaxValue().doubleValue());
        double minYValue = Math.min(0.0, this.getDataModel().getMinValue().doubleValue());
        double rangeYValue = maxYValue - minYValue;
        double ratioy = (double)graphHeight / rangeYValue;
        long x = graphPosX + this.getSpaceBetweenGroups();
        int i = 0;
        while (i < nbBar) {
            int j = 0;
            while (j < this.getModelNumber()) {
                long y = graphPosY + graphHeight;
                DataModel1D model = this.getModel(j);
                Number valueAt2 = model.getValueAt(i);
                if (valueAt2 != null) {
                    double h = valueAt2.doubleValue() * ratioy;
                    g.setColor(this.getColor(j));
                    y = (long)((double)y - (Math.ceil(h) - 1.0));
                    g.fillRect((int)x, (int)y, this.getBarWidth(), (int)h);
                }
                x += (long)(this.getBarWidth() + this.getSpaceBetweenBars());
                ++j;
            }
            x += (long)this.getSpaceBetweenGroups().intValue();
            ++i;
        }
        if (this.highlight != null && (valueAt = this.highlight.getModel().getValueAt(this.highlight.getIndexOnModel())) != null) {
            double h = valueAt.doubleValue() * ratioy;
            int y = graphPosY + graphHeight;
            y = (int)((double)y - (Math.ceil(h) - 1.0));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int s = 6;
            int left = (this.highlight.getMinX() + this.highlight.getMaxX() - s) / 2;
            int top = y - s / 2;
            g.setColor(this.getColor(0));
            g.setColor(COLOR_ORANGE);
            g.fillRect(this.highlight.getMinX(), y, this.getBarWidth(), (int)h);
            g.setColor(Color.WHITE);
            g.fillOval(left, top, s, s);
        }
    }

    @Override
    public double getXFromValue(Number value) {
        double gWidth = (this.getSpaceBetweenBars() + this.getBarWidth()) * this.getDataModel().getSize();
        return (double)this.getChartRectangle().x - (gWidth + (double)this.getSpaceBetweenGroups().intValue()) / 2.0 + (gWidth + (double)this.getSpaceBetweenGroups().intValue()) * (double)value.longValue();
    }

    @Override
    public void setChartRectangle(Rectangle r) {
        if (r.equals(this.getChartRectangle())) {
            return;
        }
        super.setChartRectangle(r);
        this.indexes.clear();
        int nbBar = this.getBarNumber();
        int graphPosX = this.getChartRectangle().x;
        long x = graphPosX + this.getSpaceBetweenGroups();
        int i = 0;
        while (i < nbBar) {
            int j = 0;
            while (j < this.getModelNumber()) {
                DataModel1D model = this.getModel(j);
                GraphIndex index = new GraphIndex(model, i, (int)x, (int)(x + (long)this.getBarWidth()));
                this.indexes.add(index);
                x += (long)(this.getBarWidth() + this.getSpaceBetweenBars());
                ++j;
            }
            x += (long)this.getSpaceBetweenGroups().intValue();
            ++i;
        }
    }

    @Override
    public Number highLightAt(int x, int y) {
        int stop = this.indexes.size();
        GraphIndex found = null;
        int i = 0;
        while (i < stop) {
            GraphIndex index = this.indexes.get(i);
            if (index.containsX(x)) {
                found = index;
                break;
            }
            ++i;
        }
        if (this.highlight != found) {
            this.highlight = found;
            this.getDataModel().fireDataModelChanged();
        }
        if (this.highlight != null) {
            return this.highlight.getModel().getValueAt(this.highlight.getIndexOnModel());
        }
        return null;
    }

    public GraphIndex getHighlight() {
        return this.highlight;
    }
}

