/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jopenchart.AreaRenderer;
import org.jopenchart.Axis;
import org.jopenchart.DataModel;
import org.jopenchart.SolidAreaRenderer;

public class Chart {
    public static final Color COLOR_ORANGE = new Color(255, 157, 9);
    private String titleText;
    private Font titleFont;
    private Color titleColor;
    protected Axis top;
    protected Axis bottom;
    protected Axis left;
    protected Axis right;
    protected List<Color> definedColors = new ArrayList<Color>(1);
    private static final AreaRenderer DEFAULT_AREA_RENDER = new SolidAreaRenderer(Color.WHITE);
    private AreaRenderer bgRenderer = DEFAULT_AREA_RENDER;
    private Dimension dimension;
    protected DataModel model;
    private Rectangle chartRectangle;

    public Chart() {
        this.definedColors.add(new Color(255, 150, 0));
    }

    public void setChartRectangle(Rectangle r) {
        if (this.chartRectangle == null || !r.equals(this.chartRectangle)) {
            this.chartRectangle = r;
        }
    }

    public Rectangle getChartRectangle() {
        return this.chartRectangle;
    }

    void setTitle(String title) {
        this.titleText = title;
    }

    void setTitleFont(Font font) {
        this.titleFont = font;
    }

    void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public void setColor(Color color) {
        this.definedColors.clear();
        this.definedColors.add(color);
    }

    public void setColors(List<Color> colors) {
        this.definedColors.clear();
        this.definedColors.addAll(colors);
    }

    public Color getColor(int index) {
        if (index >= this.definedColors.size()) {
            return COLOR_ORANGE;
        }
        return this.definedColors.get(index);
    }

    public void setBackgroundRenderer(AreaRenderer renderer) {
        this.bgRenderer = renderer;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void render(Graphics2D g) {
        this.prepareRendering(g);
        this.renderBackground(g);
        this.renderAxis(g);
        this.renderPlot(g);
        this.renderLabels(g);
    }

    public void prepareRendering(Graphics2D g) {
    }

    public void renderBackground(Graphics2D g) {
        this.bgRenderer.render(g);
        if (this.model.getState() == 0) {
            g.setColor(Color.LIGHT_GRAY);
            String str = "Chargement des donn\u00e9es en cours...";
            Rectangle2D r = g.getFontMetrics().getStringBounds("Chargement des donn\u00e9es en cours...", g);
            double x = (double)this.getChartRectangle().x + (-r.getWidth() + (double)this.getChartRectangle().width) / 2.0;
            int y = 32;
            g.drawString("Chargement des donn\u00e9es en cours...", (int)x, y);
        }
    }

    public void renderLabels(Graphics2D g) {
    }

    public void renderPlot(Graphics2D g) {
    }

    public void renderAxis(Graphics2D g) {
    }

    public DataModel getDataModel() {
        return this.model;
    }

    public double getXFromValue(Number value) {
        throw new IllegalStateException("Unsupported");
    }

    public Number highLightAt(int x, int y) {
        return null;
    }
}

