/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.jopenchart.Axis;
import org.jopenchart.AxisLabel;

public class BottomAxis
extends Axis {
    public BottomAxis(Axis a) {
        super("x");
        this.addLabels(a.getLabels());
    }

    public BottomAxis() {
        super("x");
    }

    @Override
    public void render(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int size = this.getLabels().size();
        double dx = (double)this.getWidth() / ((double)size - 1.0);
        int i = 0;
        while (i < size) {
            AxisLabel label = this.getLabels().get(i);
            g.setColor(this.getColor());
            double x = label.getValue() != null ? this.chart.getXFromValue(label.getValue()) : (double)i * dx;
            g.drawLine((int)x, this.getY(), (int)x, this.getY() + this.getMarkerLenght());
            int labelH = g.getFontMetrics().getAscent();
            double labelW = (int)g.getFontMetrics().getStringBounds(label.getLabel(), g).getWidth() / 2 - 1;
            g.setColor(label.getColor());
            g.drawString(label.getLabel(), (int)(x - labelW), labelH + this.getY() + this.getMarkerLenght() + this.getMarkerSpacing());
            ++i;
        }
        g.setColor(this.getColor());
        g.drawLine(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY());
    }
}

