/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.tree;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;

public class DefaultXTreeCellEditor
extends DefaultTreeCellEditor {
    public DefaultXTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
    }

    public DefaultXTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        super(tree, renderer, editor);
    }

    public void setRenderer(DefaultTreeCellRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    protected Container createContainer() {
        return new XEditorContainer();
    }

    @Override
    protected void prepareForEditing() {
        super.prepareForEditing();
        this.applyComponentOrientation();
    }

    protected void applyComponentOrientation() {
        if (this.tree != null) {
            this.editingContainer.applyComponentOrientation(this.tree.getComponentOrientation());
        }
    }

    private boolean isRightToLeft() {
        return this.tree != null && !this.tree.getComponentOrientation().isLeftToRight();
    }

    public class XEditorContainer
    extends DefaultTreeCellEditor.EditorContainer {
        public XEditorContainer() {
            super(DefaultXTreeCellEditor.this);
        }

        @Override
        public Dimension getPreferredSize() {
            if (DefaultXTreeCellEditor.this.isRightToLeft()) {
                if (DefaultXTreeCellEditor.this.editingComponent != null) {
                    Dimension rSize;
                    Dimension pSize = DefaultXTreeCellEditor.this.editingComponent.getPreferredSize();
                    pSize.width += DefaultXTreeCellEditor.this.offset + 5;
                    Dimension dimension = rSize = DefaultXTreeCellEditor.this.renderer != null ? DefaultXTreeCellEditor.this.renderer.getPreferredSize() : null;
                    if (rSize != null) {
                        pSize.height = Math.max(pSize.height, rSize.height);
                    }
                    if (DefaultXTreeCellEditor.this.editingIcon != null) {
                        pSize.height = Math.max(pSize.height, DefaultXTreeCellEditor.this.editingIcon.getIconHeight());
                    }
                    return pSize;
                }
                return new Dimension(0, 0);
            }
            return super.getPreferredSize();
        }

        @Override
        public void doLayout() {
            if (DefaultXTreeCellEditor.this.isRightToLeft()) {
                Dimension cSize = this.getSize();
                DefaultXTreeCellEditor.this.editingComponent.getPreferredSize();
                DefaultXTreeCellEditor.this.editingComponent.setLocation(0, 0);
                DefaultXTreeCellEditor.this.editingComponent.setBounds(0, 0, cSize.width - DefaultXTreeCellEditor.this.offset, cSize.height);
            } else {
                super.doLayout();
            }
        }

        @Override
        public void paint(Graphics g) {
            if (DefaultXTreeCellEditor.this.isRightToLeft()) {
                Dimension size = this.getSize();
                if (DefaultXTreeCellEditor.this.editingIcon != null) {
                    int yLoc = Math.max(0, (size.height - DefaultXTreeCellEditor.this.editingIcon.getIconHeight()) / 2);
                    int xLoc = Math.max(0, size.width - DefaultXTreeCellEditor.this.offset);
                    DefaultXTreeCellEditor.this.editingIcon.paintIcon(this, g, xLoc, yLoc);
                }
                Icon rememberIcon = DefaultXTreeCellEditor.this.editingIcon;
                DefaultXTreeCellEditor.this.editingIcon = null;
                super.paint(g);
                DefaultXTreeCellEditor.this.editingIcon = rememberIcon;
            } else {
                super.paint(g);
            }
        }
    }
}

