/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.aqua.AquaLookAndFeelAddons;
import org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons;
import org.jdesktop.swingx.plaf.motif.MotifLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

public class LookAndFeelAddons {
    private static List contributedComponents = new ArrayList();
    private static final Object APPCONTEXT_INITIALIZED = new Object();
    private static boolean trackingChanges = false;
    private static PropertyChangeListener changeListener;
    private static LookAndFeelAddons currentAddon;

    static {
        String addonClassname = LookAndFeelAddons.getBestMatchAddonClassName();
        try {
            addonClassname = System.getProperty("swing.addon", addonClassname);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            LookAndFeelAddons.setAddon(addonClassname);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        LookAndFeelAddons.setTrackingLookAndFeelChanges(true);
        LookAndFeelAddons.contribute(new AbstractComponentAddon("MinimumAddon"){

            @Override
            protected void addBasicDefaults(LookAndFeelAddons addon, List defaults) {
                this.addResource(defaults, "org.jdesktop.swingx.plaf.resources.swingx");
            }
        });
    }

    public void initialize() {
        for (ComponentAddon addon : contributedComponents) {
            addon.initialize(this);
        }
    }

    public void uninitialize() {
        for (ComponentAddon addon : contributedComponents) {
            addon.uninitialize(this);
        }
    }

    public void loadDefaults(Object[] keysAndValues) {
        int i = 0;
        int c = keysAndValues.length;
        while (i < c) {
            UIManager.getLookAndFeelDefaults().put(keysAndValues[i], keysAndValues[i + 1]);
            i += 2;
        }
    }

    public void unloadDefaults(Object[] keysAndValues) {
        int i = 0;
        int c = keysAndValues.length;
        while (i < c) {
            UIManager.getLookAndFeelDefaults().put(keysAndValues[i], (Object)null);
            i += 2;
        }
    }

    public static void setAddon(String addonClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LookAndFeelAddons.setAddon(Class.forName(addonClassName));
    }

    public static void setAddon(Class addonClass) throws InstantiationException, IllegalAccessException {
        LookAndFeelAddons addon = (LookAndFeelAddons)addonClass.newInstance();
        LookAndFeelAddons.setAddon(addon);
    }

    public static void setAddon(LookAndFeelAddons addon) {
        if (currentAddon != null) {
            currentAddon.uninitialize();
        }
        addon.initialize();
        currentAddon = addon;
        UIManager.put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
    }

    public static LookAndFeelAddons getAddon() {
        return currentAddon;
    }

    public static String getBestMatchAddonClassName() {
        String lnf = UIManager.getLookAndFeel().getClass().getName();
        String addon = UIManager.getCrossPlatformLookAndFeelClassName().equals(lnf) ? MetalLookAndFeelAddons.class.getName() : (UIManager.getSystemLookAndFeelClassName().equals(lnf) ? LookAndFeelAddons.getSystemAddonClassName() : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lnf) || "com.jgoodies.looks.windows.WindowsLookAndFeel".equals(lnf) ? (OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName()) : ("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(lnf) ? WindowsClassicLookAndFeelAddons.class.getName() : (UIManager.getLookAndFeel().getID().equals("Motif") ? MotifLookAndFeelAddons.class.getName() : LookAndFeelAddons.getSystemAddonClassName()))));
        return addon;
    }

    public static String getSystemAddonClassName() {
        String addon = WindowsClassicLookAndFeelAddons.class.getName();
        if (OS.isMacOSX()) {
            addon = AquaLookAndFeelAddons.class.getName();
        } else if (OS.isWindows()) {
            addon = OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName();
        }
        return addon;
    }

    public static void contribute(ComponentAddon component) {
        contributedComponents.add(component);
        if (currentAddon != null) {
            component.initialize(currentAddon);
        }
    }

    public static void uncontribute(ComponentAddon component) {
        contributedComponents.remove(component);
        if (currentAddon != null) {
            component.uninitialize(currentAddon);
        }
    }

    public static ComponentUI getUI(JComponent component, Class expectedUIClass) {
        Class<?> realUIClass;
        LookAndFeelAddons.maybeInitialize();
        String uiClassname = (String)UIManager.get(component.getUIClassID());
        try {
            Class<?> uiClass = Class.forName(uiClassname);
            UIManager.put(uiClassname, uiClass);
        }
        catch (ClassNotFoundException uiClass) {
            // empty catch block
        }
        ComponentUI ui = UIManager.getUI(component);
        if (expectedUIClass.isInstance(ui)) {
            return ui;
        }
        String realUI = ui.getClass().getName();
        try {
            realUIClass = expectedUIClass.getClassLoader().loadClass(realUI);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + realUI, e);
        }
        Method createUIMethod = null;
        try {
            createUIMethod = realUIClass.getMethod("createUI", JComponent.class);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException("Class " + realUI + " has no method createUI(JComponent)");
        }
        try {
            return (ComponentUI)createUIMethod.invoke(null, component);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to invoke " + realUI + "#createUI(JComponent)");
        }
    }

    private static synchronized void maybeInitialize() {
        if (currentAddon != null) {
            UIManager.getLookAndFeelDefaults();
            if (!UIManager.getBoolean(APPCONTEXT_INITIALIZED)) {
                LookAndFeelAddons.setAddon(currentAddon);
            }
        }
    }

    public static synchronized void setTrackingLookAndFeelChanges(boolean tracking) {
        if (trackingChanges != tracking) {
            if (tracking) {
                if (changeListener == null) {
                    changeListener = new UpdateAddon();
                }
                UIManager.addPropertyChangeListener(changeListener);
            } else {
                if (changeListener != null) {
                    UIManager.removePropertyChangeListener(changeListener);
                }
                changeListener = null;
            }
            trackingChanges = tracking;
        }
    }

    public static synchronized boolean isTrackingLookAndFeelChanges() {
        return trackingChanges;
    }

    private static class UpdateAddon
    implements PropertyChangeListener {
        private UpdateAddon() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

