/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.UIManager;

public abstract class ContextMenuSource {
    private Map names;

    public abstract String[] getKeys();

    public String getName(String actionKey) {
        return (String)this.getNames().get(actionKey);
    }

    public abstract void updateActionEnabled(JComponent var1, ActionMap var2);

    public ActionMap createActionMap(JComponent component) {
        ActionMap map = new ActionMap();
        String[] keys = this.getKeys();
        int i = 0;
        while (i < keys.length) {
            Action action;
            if (keys[i] != null && (action = this.createDelegateAction(component, keys[i])) != null) {
                map.put(keys[i], action);
            }
            ++i;
        }
        return map;
    }

    protected Map getNames() {
        if (this.names == null) {
            this.names = new HashMap();
            this.initNames(this.names);
        }
        return this.names;
    }

    protected String getValue(String key, String defaultValue) {
        String value = UIManager.getString(String.valueOf(this.getResourcePrefix()) + key);
        return value != null ? value : defaultValue;
    }

    protected abstract void initNames(Map var1);

    protected abstract String getResourcePrefix();

    protected Action createDelegateAction(JComponent component, String actionKey) {
        Action action = component.getActionMap().get(actionKey);
        if (action != null) {
            return new DelegateAction(this.getName(actionKey), action, component);
        }
        return null;
    }

    public static class DelegateAction
    extends AbstractAction {
        private Action delegatee;
        private JComponent target;

        public DelegateAction(String name, Action delegatee, JComponent target) {
            super(name);
            this.delegatee = delegatee;
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegatee.actionPerformed(this.createActionEvent(e));
        }

        private ActionEvent createActionEvent(ActionEvent e) {
            if (this.target != null) {
                return new ActionEvent(this.target, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            }
            return e;
        }
    }
}

