/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.MenuElement;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.MessageSource;

public class MouseMessagingHandler
extends MouseAdapter {
    private Object source;
    private MessageSource messageSource;
    private MessageListener messageListener;

    public MouseMessagingHandler(Object source, MessageSource messageSource) {
        this.setSource(source);
        this.setMessageSource(messageSource);
    }

    public MouseMessagingHandler(Object source, MessageListener messageListener) {
        this.setSource(source);
        this.setMessageListener(messageListener);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.fireMessage("");
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        AbstractButton button;
        Action action;
        if (evt.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)evt.getSource()).getAction()) != null) {
            this.fireMessage((String)action.getValue("LongDescription"));
        }
    }

    public void registerListeners(MenuElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof AbstractButton) {
                ((AbstractButton)((Object)elements[i])).addMouseListener(this);
            }
            this.registerListeners(elements[i].getSubElements());
            ++i;
        }
    }

    public void unregisterListeners(MenuElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof AbstractButton) {
                ((AbstractButton)((Object)elements[i])).removeMouseListener(this);
            }
            this.unregisterListeners(elements[i].getSubElements());
            ++i;
        }
    }

    public void registerListeners(Component[] components) {
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof AbstractButton) {
                components[i].addMouseListener(this);
            }
            ++i;
        }
    }

    public void unregisterListeners(Component[] components) {
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof AbstractButton) {
                components[i].removeMouseListener(this);
            }
            ++i;
        }
    }

    private void fireMessage(String message) {
        MessageEvent evt = new MessageEvent(this.source, message, Level.FINE);
        if (this.messageListener != null) {
            this.messageListener.message(evt);
        }
        if (this.messageSource != null) {
            MessageListener[] ls = this.messageSource.getMessageListeners();
            int i = 0;
            while (i < ls.length) {
                ls[i].message(evt);
                ++i;
            }
        }
    }
}

