/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.action.LinkAction;

public class LinkRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ListCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private JXHyperlink linkButton;
    private LinkAction linkAction = new LinkAction(null);

    public LinkRenderer() {
        this(null);
    }

    public LinkRenderer(ActionListener visitingDelegate) {
        this.linkButton = this.createHyperlink(this.linkAction);
        this.linkButton.addActionListener(this.createEditorActionListener());
        this.setVisitingDelegate(visitingDelegate);
    }

    private JXHyperlink createHyperlink(Action linkAction) {
        return new JXHyperlink(linkAction){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBorderPainted(true);
                this.setOpaque(true);
            }
        };
    }

    public void setVisitingDelegate(ActionListener openAction) {
        this.linkAction.setVisitingDelegate(openAction);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.linkAction.setLink(value instanceof LinkModel ? (LinkModel)value : null);
        Point p = (Point)list.getClientProperty("swingx.rollover");
        if (p != null && p.y >= 0 && p.y == index) {
            this.linkButton.getModel().setRollover(true);
        } else {
            this.linkButton.getModel().setRollover(false);
        }
        this.updateSelectionColors(list, isSelected);
        this.updateFocusBorder(cellHasFocus);
        return this.linkButton;
    }

    private void updateSelectionColors(JList table, boolean isSelected) {
        if (isSelected) {
            this.linkButton.setBackground(table.getSelectionBackground());
        } else {
            this.linkButton.setBackground(table.getBackground());
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.linkAction.setLink(value instanceof LinkModel ? (LinkModel)value : null);
        Point p = (Point)table.getClientProperty("swingx.rollover");
        if (p != null && p.x >= 0 && p.x == column && p.y == row) {
            this.linkButton.getModel().setRollover(true);
        } else {
            this.linkButton.getModel().setRollover(false);
        }
        this.updateSelectionColors(table, isSelected);
        this.updateFocusBorder(hasFocus);
        return this.linkButton;
    }

    private void updateSelectionColors(JTable table, boolean isSelected) {
        if (isSelected) {
            this.linkButton.setBackground(table.getSelectionBackground());
        } else {
            this.linkButton.setBackground(table.getBackground());
        }
    }

    private void updateFocusBorder(boolean hasFocus) {
        if (hasFocus) {
            this.linkButton.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.linkButton.setBorder(noFocusBorder);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.linkAction.setLink(value instanceof LinkModel ? (LinkModel)value : null);
        this.linkButton.getModel().setRollover(true);
        this.updateSelectionColors(table, isSelected);
        return this.linkButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.linkAction.getLink();
    }

    private ActionListener createEditorActionListener() {
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkRenderer.this.fireEditingStopped();
            }
        };
        return l;
    }
}

