/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.FieldAccess;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class NameVisitor
extends VisitorObject {
    private final Context context;

    public NameVisitor(Context ctx) {
        this.context = ctx;
    }

    @Override
    public Object visit(PackageDeclaration node) {
        this.context.setCurrentPackage(node.getName());
        return null;
    }

    @Override
    public Object visit(ImportDeclaration node) {
        if (node.isPackage()) {
            this.context.declarePackageImport(node.getName());
        } else {
            try {
                this.context.declareClassImport(node.getName());
            }
            catch (ClassNotFoundException e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        return null;
    }

    @Override
    public Object visit(WhileStatement node) {
        Node n = node.getCondition();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setBody((Node)o);
        }
        return null;
    }

    @Override
    public Object visit(ForStatement node) {
        Object o;
        Node n;
        this.context.enterScope();
        List l = node.getInitialization();
        if (l != null) {
            this.visitList(l);
        }
        if ((n = node.getCondition()) != null && (o = n.acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setCondition((Expression)o);
        }
        if ((l = node.getUpdate()) != null) {
            this.visitList(l);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setBody((Node)o);
        }
        this.context.leaveScope();
        return null;
    }

    @Override
    public Object visit(DoStatement node) {
        Node n = node.getCondition();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setBody((Node)o);
        }
        return null;
    }

    @Override
    public Object visit(SwitchStatement node) {
        Expression exp = node.getSelector();
        Object o = exp.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", exp);
            }
            node.setSelector((Expression)o);
        }
        Iterator it = node.getBindings().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Object visit(SwitchBlock node) {
        List l;
        Expression exp = node.getExpression();
        if (exp != null) {
            this.visitExpressionContainer(node);
        }
        if ((l = node.getStatements()) != null) {
            this.visitList(l);
        }
        return null;
    }

    @Override
    public Object visit(LabeledStatement node) {
        Node n = node.getStatement();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setStatement((Expression)o);
        }
        return null;
    }

    @Override
    public Object visit(ThrowStatement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(SynchronizedStatement node) {
        Node n = node.getLock();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setLock((Expression)o);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setBody((Node)o);
        }
        return null;
    }

    @Override
    public Object visit(TryStatement node) {
        node.getTryBlock().acceptVisitor(this);
        Iterator it = node.getCatchStatements().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        Node n = node.getFinallyBlock();
        if (n != null) {
            n.acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Object visit(CatchStatement node) {
        this.context.enterScope();
        node.getException().acceptVisitor(this);
        node.getBlock().acceptVisitor(this);
        this.context.leaveScope();
        return null;
    }

    @Override
    public Object visit(ReturnStatement node) {
        Expression e = node.getExpression();
        if (e != null) {
            this.visitExpressionContainer(node);
        }
        return null;
    }

    @Override
    public Object visit(IfThenStatement node) {
        Node n = node.getCondition();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getThenStatement()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setThenStatement((Node)o);
        }
        return null;
    }

    @Override
    public Object visit(IfThenElseStatement node) {
        Node n = node.getCondition();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getThenStatement()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setThenStatement((Node)o);
        }
        if ((o = (n = node.getElseStatement()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setElseStatement((Node)o);
        }
        return null;
    }

    @Override
    public Object visit(VariableDeclaration node) {
        Object o;
        String s = node.getName();
        if (this.context.isDefinedVariable(s)) {
            node.setProperty("errorStrings", new String[]{s});
            throw new ExecutionError("variable.redefinition", node);
        }
        if (node.isFinal()) {
            this.context.defineConstant(s, null);
        } else {
            this.context.define(s, null);
        }
        Expression n = node.getInitializer();
        if (n != null && (o = n.acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setInitializer((Expression)o);
        }
        return null;
    }

    @Override
    public Object visit(SimpleAssignExpression node) {
        Expression left;
        Expression right = node.getRightExpression();
        Object o = right.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("right.expression", right);
            }
            node.setRightExpression((Expression)o);
        }
        if ((left = node.getLeftExpression()) instanceof QualifiedName) {
            List ids = ((QualifiedName)left).getIdentifiers();
            String var = ((IdentifierToken)ids.get(0)).image();
            if (ids.size() == 1 && !this.context.exists(var)) {
                this.context.define(var, null);
            }
        }
        if ((o = left.acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("left.expression", node);
            }
            node.setLeftExpression((Expression)o);
        }
        return null;
    }

    @Override
    public Object visit(BlockStatement node) {
        this.context.enterScope();
        this.visitList(node.getStatements());
        this.context.leaveScope();
        return null;
    }

    @Override
    public Object visit(ObjectFieldAccess node) {
        Object o = node.getExpression().acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                return new StaticFieldAccess((ReferenceType)o, node.getFieldName(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
            }
            node.setExpression((Expression)o);
        }
        return null;
    }

    @Override
    public Object visit(ObjectMethodCall node) {
        Object o;
        Expression exp;
        List args = node.getArguments();
        if (args != null) {
            this.visitList(args);
        }
        if ((exp = node.getExpression()) == null) {
            o = this.context.getDefaultQualifier(node);
        } else {
            o = exp.acceptVisitor(this);
            if (o == null) {
                return null;
            }
        }
        if (o == null) {
            return new FunctionCall(node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
        }
        if (o instanceof ReferenceType) {
            return new StaticMethodCall((ReferenceType)o, node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
        }
        node.setExpression((Expression)o);
        return null;
    }

    @Override
    public Object visit(SuperMethodCall node) {
        List args = node.getArguments();
        if (args != null) {
            this.visitList(args);
        }
        return null;
    }

    @Override
    public Object visit(ThisExpression node) {
        return this.context.getDefaultQualifier(node, node.getClassName());
    }

    @Override
    public Object visit(QualifiedName node) {
        List ids = node.getIdentifiers();
        IdentifierToken t = (IdentifierToken)ids.get(0);
        if (this.context.isDefined(t.image())) {
            Expression result = this.context.createName(node, t);
            Iterator it = ids.iterator();
            it.next();
            while (it.hasNext()) {
                IdentifierToken t2 = (IdentifierToken)it.next();
                result = new ObjectFieldAccess(result, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            }
            return result;
        }
        List l = (List)((LinkedList)ids).clone();
        boolean b = false;
        while (l.size() > 0) {
            String s = TreeUtilities.listToName(l);
            b = this.context.classExists(s);
            if (b) break;
            l.remove(l.size() - 1);
        }
        if (!b) {
            node.setProperty("errorStrings", new String[]{t.image()});
            throw new ExecutionError("undefined.class", node);
        }
        IdentifierToken t2 = (IdentifierToken)l.get(l.size() - 1);
        ReferenceType rt = new ReferenceType(l, node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
        if (l.size() != ids.size()) {
            ListIterator it = ids.listIterator(l.size());
            t2 = (IdentifierToken)it.next();
            FieldAccess result = new StaticFieldAccess(rt, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            while (it.hasNext()) {
                t2 = (IdentifierToken)it.next();
                result = new ObjectFieldAccess(result, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            }
            return result;
        }
        return rt;
    }

    @Override
    public Object visit(SimpleAllocation node) {
        List args = node.getArguments();
        if (args != null) {
            this.visitList(args);
        }
        return null;
    }

    @Override
    public Object visit(ArrayAllocation node) {
        this.visitList(node.getSizes());
        if (node.getInitialization() != null) {
            node.getInitialization().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Object visit(InnerAllocation node) {
        this.visitExpressionContainer(node);
        List args = node.getArguments();
        if (args != null) {
            this.visitList(args);
        }
        return null;
    }

    @Override
    public Object visit(ArrayInitializer node) {
        this.visitList(node.getCells());
        return null;
    }

    @Override
    public Object visit(ArrayAccess node) {
        this.visitExpressionContainer(node);
        Expression n = node.getCellNumber();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setCellNumber((Expression)o);
        }
        return null;
    }

    @Override
    public Object visit(NotExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(ComplementExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(PlusExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(MinusExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(AddExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(AddAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(SubtractExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(SubtractAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(MultiplyExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(MultiplyAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(DivideExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(DivideAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(RemainderExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(RemainderAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(EqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(NotEqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(LessExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(LessOrEqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(GreaterExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(GreaterOrEqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(BitAndExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(BitAndAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(ExclusiveOrExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(ExclusiveOrAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(BitOrExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(BitOrAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(ShiftLeftExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(ShiftLeftAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(ShiftRightExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(ShiftRightAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(UnsignedShiftRightExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(UnsignedShiftRightAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(AndExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(OrExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Object visit(InstanceOfExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(ConditionalExpression node) {
        Expression n = node.getConditionExpression();
        Object o = n.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            node.setConditionExpression((Expression)o);
        }
        if ((o = (n = node.getIfTrueExpression()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.second.operand", n);
            }
            node.setIfTrueExpression((Expression)o);
        }
        if ((o = (n = node.getIfFalseExpression()).acceptVisitor(this)) != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.third.operand", n);
            }
            node.setIfFalseExpression((Expression)o);
        }
        return null;
    }

    @Override
    public Object visit(PostIncrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(PreIncrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(PostDecrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(PreDecrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(CastExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Object visit(ClassAllocation node) {
        List largs = node.getArguments();
        if (largs != null) {
            this.visitList(largs);
        }
        return null;
    }

    @Override
    public Object visit(InnerClassAllocation node) {
        this.visitExpressionContainer(node);
        List largs = node.getArguments();
        if (largs != null) {
            this.visitList(largs);
        }
        return null;
    }

    @Override
    public Object visit(FormalParameter node) {
        if (node.isFinal()) {
            this.context.defineConstant(node.getName(), null);
        } else {
            this.context.define(node.getName(), null);
        }
        return null;
    }

    @Override
    public Object visit(ClassDeclaration node) {
        this.context.defineClass(node);
        return null;
    }

    @Override
    public Object visit(InterfaceDeclaration node) {
        this.context.defineClass(node);
        return null;
    }

    private void visitExpressionContainer(ExpressionContainer node) {
        Expression exp = node.getExpression();
        Object o = exp.acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", exp);
            }
            node.setExpression((Expression)o);
        }
    }

    private void visitBinaryExpression(BinaryExpression node) {
        Object o = node.getLeftExpression().acceptVisitor(this);
        if (o != null) {
            if (o instanceof Expression) {
                node.setLeftExpression((Expression)o);
            } else {
                throw new ExecutionError("left.operand", node);
            }
        }
        if ((o = node.getRightExpression().acceptVisitor(this)) != null) {
            if (o instanceof Expression) {
                node.setRightExpression((Expression)o);
            } else {
                throw new ExecutionError("right.operand", node);
            }
        }
    }

    private void visitList(List l) {
        ListIterator<Object> it = l.listIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Object o = n.acceptVisitor(this);
            if (o == null) continue;
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            it.set(o);
        }
    }
}

