/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.parser.wrapper.ParseError;

public class InterpreterException
extends Exception {
    protected SourceInformation sourceInformation;
    protected String message;

    public InterpreterException(ParseError e) {
        if (e.getLine() != -1) {
            System.err.println("InterpreterException.InterpreterException() Parse");
            this.sourceInformation = new SourceInformation(e.getFilename(), e.getLine(), e.getColumn());
            this.message = e.getMessage();
        } else {
            System.err.println("InterpreterException.InterpreterException() pas de ligne");
            this.message = e.getMessage();
        }
    }

    public InterpreterException(ExecutionError e) {
        this.message = e instanceof CatchedExceptionError ? ((CatchedExceptionError)e).getException().toString() : (e instanceof ThrownException ? ((ThrownException)e).getException().toString() : e.getMessage());
    }

    @Override
    public String toString() {
        return "InterpreterException:" + this.message + " source:" + this.sourceInformation;
    }

    public SourceInformation getSourceInformation() {
        return this.sourceInformation;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static class SourceInformation {
        private final String filename;
        private final int line;
        private final int column;

        public SourceInformation(String filename, int line, int column) {
            this.filename = filename;
            this.line = line;
            this.column = column;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            return "[" + this.filename + " (" + this.line + "," + this.column + ")]";
        }
    }
}

