/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.ButtonFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;

public class StringList
extends JPanel
implements ActionMap {
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.stringlist";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("koala.dynamicjava.gui.resources.stringlist", Locale.getDefault());
    protected JList list;
    protected DefaultListModel listModel = new DefaultListModel();
    protected JButton removeButton;
    protected JButton upButton;
    protected JButton downButton;
    protected Map listeners = new HashMap();

    public StringList(Action addAction) {
        super(new BorderLayout());
        this.listeners.put("AddButtonAction", addAction);
        this.listeners.put("RemoveButtonAction", new RemoveButtonAction());
        this.listeners.put("UpButtonAction", new UpButtonAction());
        this.listeners.put("DownButtonAction", new DownButtonAction());
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionAdapter());
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(this.list);
        this.add(sp);
        JPanel bp = new JPanel(new FlowLayout(1));
        this.add("South", bp);
        ButtonFactory bf = new ButtonFactory(bundle, this);
        bp.add(bf.createJButton("AddButton"));
        this.removeButton = bf.createJButton("RemoveButton");
        bp.add(this.removeButton);
        this.upButton = bf.createJButton("UpButton");
        bp.add(this.upButton);
        this.downButton = bf.createJButton("DownButton");
        bp.add(this.downButton);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    public String[] getStrings() {
        Object[] t1 = this.listModel.toArray();
        String[] t2 = new String[t1.length];
        int i = 0;
        while (i < t1.length) {
            t2[i] = (String)t1[i];
            ++i;
        }
        return t2;
    }

    public void setStrings(String[] strings) {
        this.listModel.clear();
        int i = 0;
        while (i < strings.length) {
            this.listModel.addElement(strings[i]);
            ++i;
        }
    }

    public void add(String s) {
        this.listModel.addElement(s);
        this.updateButtons();
    }

    protected void updateButtons() {
        int size = this.listModel.size();
        int i = this.list.getSelectedIndex();
        boolean empty = size == 0;
        boolean selected = i != -1;
        boolean zeroSelected = i == 0;
        boolean lastSelected = i == size - 1;
        this.removeButton.setEnabled(!empty && selected);
        this.upButton.setEnabled(!empty && selected && !zeroSelected);
        this.downButton.setEnabled(!empty && selected && !lastSelected);
    }

    @Override
    public Action getAction(String key) throws MissingListenerException {
        return (Action)this.listeners.get(key);
    }

    protected class DownButtonAction
    extends AbstractAction {
        protected DownButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = StringList.this.list.getSelectedIndex();
            Object o = StringList.this.listModel.getElementAt(i);
            StringList.this.listModel.removeElementAt(i);
            StringList.this.listModel.insertElementAt(o, i + 1);
            StringList.this.list.setSelectedIndex(i + 1);
        }
    }

    protected class ListSelectionAdapter
    implements ListSelectionListener {
        protected ListSelectionAdapter() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            StringList.this.removeButton.setEnabled(true);
            int i = StringList.this.list.getSelectedIndex();
            StringList.this.upButton.setEnabled(i != 0);
            StringList.this.downButton.setEnabled(i != StringList.this.listModel.size() - 1);
        }
    }

    protected class RemoveButtonAction
    extends AbstractAction {
        protected RemoveButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = StringList.this.list.getSelectedIndex();
            StringList.this.listModel.removeElementAt(i);
            StringList.this.updateButtons();
        }
    }

    protected class UpButtonAction
    extends AbstractAction {
        protected UpButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = StringList.this.list.getSelectedIndex();
            Object o = StringList.this.listModel.getElementAt(i);
            StringList.this.listModel.removeElementAt(i);
            StringList.this.listModel.insertElementAt(o, i - 1);
            StringList.this.list.setSelectedIndex(i - 1);
        }
    }
}

