/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.util.AmbiguousFieldException;

public class ClassInfoUtilities {
    public static ConstructorInfo lookupConstructor(ClassInfo cl, ClassInfo[] ac) throws NoSuchMethodException {
        List ms = ClassInfoUtilities.getConstructors(cl, ac.length);
        LinkedList<ConstructorInfo> mm = new LinkedList<ConstructorInfo>();
        for (ConstructorInfo m : ms) {
            if (!ClassInfoUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            mm.add(m);
        }
        if (mm.isEmpty()) {
            throw new NoSuchMethodException(String.valueOf(cl.getName()) + " constructor");
        }
        Iterator it = mm.iterator();
        ConstructorInfo result = (ConstructorInfo)it.next();
        while (it.hasNext()) {
            result = ClassInfoUtilities.selectTheMostSpecificConstructor(result, (ConstructorInfo)it.next());
        }
        return result;
    }

    public static boolean isAssignableFrom(ClassInfo c1, ClassInfo c2) {
        if (c1.isPrimitive()) {
            if (!c1.equals(c2)) {
                if (c2 == null || !c2.isPrimitive()) {
                    return false;
                }
                Class cl1 = c1.getJavaClass();
                Class cl2 = c2.getJavaClass();
                if (cl1 == Short.TYPE) {
                    return cl2 == Byte.TYPE;
                }
                if (cl1 == Integer.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Character.TYPE;
                }
                if (cl1 == Long.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Integer.TYPE;
                }
                if (cl1 == Float.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Integer.TYPE || cl2 == Float.TYPE;
                }
                if (cl1 == Double.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Integer.TYPE || cl2 == Float.TYPE || cl2 == Double.TYPE;
                }
                return false;
            }
            return true;
        }
        if (c2 == null || c1.equals(c2)) {
            return true;
        }
        return ClassInfoUtilities.isAncestorOf(c1, c2) || ClassInfoUtilities.isInterfaceOf(c1, c2);
    }

    public static FieldInfo getField(ClassInfo cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        ClassInfo c = cl;
        while (c != null) {
            FieldInfo[] fs = c.getFields();
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().equals(name)) {
                    return fs[i];
                }
                ++i;
            }
            ClassInfo[] ints = c.getInterfaces();
            FieldInfo f = null;
            int i2 = 0;
            while (i2 < ints.length) {
                FieldInfo tmp = null;
                try {
                    tmp = ClassInfoUtilities.getField(ints[i2], name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (tmp != null) {
                    if (f != null && !f.equals(tmp)) {
                        throw new AmbiguousFieldException(name);
                    }
                    f = tmp;
                }
                ++i2;
            }
            if (f != null) {
                return f;
            }
            c = c.getSuperclass();
        }
        throw new NoSuchFieldException(name);
    }

    public static FieldInfo getOuterField(ClassInfo cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        boolean sc = Modifier.isStatic(cl.getModifiers());
        ClassInfo c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                FieldInfo f = ClassInfoUtilities.getField(c, name);
                if (!sc || Modifier.isStatic(f.getModifiers())) {
                    return f;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchFieldException(name);
    }

    public static MethodInfo lookupMethod(ClassInfo cl, String name, ClassInfo[] ac) throws NoSuchMethodException {
        List ms = ClassInfoUtilities.getMethods(cl, name, ac.length);
        LinkedList<MethodInfo> mm = new LinkedList<MethodInfo>();
        for (MethodInfo m : ms) {
            if (!ClassInfoUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            mm.add(m);
        }
        if (mm.isEmpty()) {
            throw new NoSuchMethodException(name);
        }
        Iterator it = mm.iterator();
        MethodInfo result = (MethodInfo)it.next();
        while (it.hasNext()) {
            result = ClassInfoUtilities.selectTheMostSpecificMethod(result, (MethodInfo)it.next());
        }
        return result;
    }

    public static MethodInfo lookupOuterMethod(ClassInfo cl, String name, ClassInfo[] ac) throws NoSuchMethodException {
        boolean sc = Modifier.isStatic(cl.getModifiers());
        ClassInfo c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                MethodInfo m = ClassInfoUtilities.lookupMethod(c, name, ac);
                if (!sc || Modifier.isStatic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchMethodException(name);
    }

    public static List getMethods(ClassInfo cl, String name, int params) {
        LinkedList<MethodInfo> result = new LinkedList<MethodInfo>();
        if (cl.isInterface()) {
            MethodInfo[] ms = cl.getMethods();
            int i = 0;
            while (i < ms.length) {
                if (ms[i].getName().equals(name) && ms[i].getParameterTypes().length == params) {
                    result.add(ms[i]);
                }
                ++i;
            }
            ClassInfo[] cs = cl.getInterfaces();
            int i2 = 0;
            while (i2 < cs.length) {
                result.addAll(ClassInfoUtilities.getMethods(cs[i2], name, params));
                ++i2;
            }
        } else {
            ClassInfo c = cl;
            while (c != null) {
                MethodInfo[] ms = c.getMethods();
                int i = 0;
                while (i < ms.length) {
                    if (ms[i].getName().equals(name) && ms[i].getParameterTypes().length == params) {
                        result.add(ms[i]);
                    }
                    ++i;
                }
                c = c.getSuperclass();
            }
        }
        return result;
    }

    private static List getConstructors(ClassInfo cl, int params) {
        LinkedList<ConstructorInfo> result = new LinkedList<ConstructorInfo>();
        ConstructorInfo[] ms = cl.getConstructors();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getParameterTypes().length == params) {
                result.add(ms[i]);
            }
            ++i;
        }
        return result;
    }

    private static ConstructorInfo selectTheMostSpecificConstructor(ConstructorInfo m1, ConstructorInfo m2) {
        ClassInfo[] a1 = m1.getParameterTypes();
        ClassInfo[] a2 = m2.getParameterTypes();
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                return ClassInfoUtilities.isAssignableFrom(a1[i], a2[i]) ? m2 : m1;
            }
            ++i;
        }
        return m1;
    }

    private static MethodInfo selectTheMostSpecificMethod(MethodInfo m1, MethodInfo m2) {
        ClassInfo[] a1 = m1.getParameterTypes();
        ClassInfo[] a2 = m2.getParameterTypes();
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                return ClassInfoUtilities.isAssignableFrom(a1[i], a2[i]) ? m2 : m1;
            }
            ++i;
        }
        return m1;
    }

    private static boolean hasCompatibleSignatures(ClassInfo[] a1, ClassInfo[] a2) {
        int i = 0;
        while (i < a1.length) {
            if (!ClassInfoUtilities.isAssignableFrom(a1[i], a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAncestorOf(ClassInfo c1, ClassInfo c2) {
        ClassInfo ci = c2.getSuperclass();
        while (ci != null && !ci.equals(new JavaClassInfo(Object.class))) {
            if (ci.equals(c1)) {
                return true;
            }
            ci = ci.getSuperclass();
        }
        return ci != null && ci.equals(c1);
    }

    private static boolean isInterfaceOf(ClassInfo c1, ClassInfo c2) {
        if (c1.isInterface()) {
            ClassInfo ci = c2;
            while (ci != null && !ci.equals(new JavaClassInfo(Object.class))) {
                ClassInfo[] intf = ci.getInterfaces();
                int i = 0;
                while (i < intf.length) {
                    if (intf[i].equals(c1)) {
                        return true;
                    }
                    if (ClassInfoUtilities.isInterfaceOf(c1, intf[i])) {
                        return true;
                    }
                    ++i;
                }
                ci = ci.getSuperclass();
            }
            return false;
        }
        return false;
    }

    private ClassInfoUtilities() {
    }
}

