/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.AttributeOwnerComponent;
import koala.dynamicjava.classfile.CodeAttribute;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ExceptionsAttribute;
import koala.dynamicjava.classfile.JVMUtilities;

public class MethodInfo
extends AttributeOwnerComponent {
    private short descriptorIndex;

    public MethodInfo(ConstantPool cp, String rt, String nm, String[] pt) {
        this.constantPool = cp;
        this.nameIndex = this.constantPool.putUTF8(nm);
        this.setSignature(rt, pt);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.accessFlags);
        out.writeShort(this.nameIndex);
        out.writeShort(this.descriptorIndex);
        out.writeShort(this.attributes.size());
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            ((AttributeInfo)it.next()).write(out);
        }
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public void setPrivate() {
        this.accessFlags = (short)(this.accessFlags | 2);
    }

    public void setProtected() {
        this.accessFlags = (short)(this.accessFlags | 4);
    }

    public void setStatic() {
        this.accessFlags = (short)(this.accessFlags | 8);
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public void setSynchronized() {
        this.accessFlags = (short)(this.accessFlags | 0x20);
    }

    public void setNative() {
        this.accessFlags = (short)(this.accessFlags | 0x100);
    }

    public void setAbstract() {
        this.accessFlags = (short)(this.accessFlags | 0x400);
    }

    public void setStrict() {
        this.accessFlags = (short)(this.accessFlags | 0x800);
    }

    public ExceptionsAttribute createExceptionsAttribute() {
        ExceptionsAttribute result = new ExceptionsAttribute(this.constantPool);
        this.attributes.add(result);
        return result;
    }

    public CodeAttribute createCodeAttribute() {
        CodeAttribute result = new CodeAttribute(this.constantPool);
        this.attributes.add(result);
        return result;
    }

    private void setSignature(String rt, String[] pt) {
        String r = JVMUtilities.getReturnTypeName(rt);
        String[] p = new String[pt.length];
        int i = 0;
        while (i < pt.length) {
            p[i] = JVMUtilities.getParameterTypeName(pt[i]);
            ++i;
        }
        String sig = JVMUtilities.createMethodDescriptor(r, p);
        this.descriptorIndex = this.constantPool.putUTF8(sig);
    }
}

