/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.AttributeOwnerComponent;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.FieldInfo;
import koala.dynamicjava.classfile.InnerClassesAttribute;
import koala.dynamicjava.classfile.JVMUtilities;
import koala.dynamicjava.classfile.MethodInfo;

public class ClassFile
extends AttributeOwnerComponent {
    private static final int MAGIC = -889275714;
    private static final short MAJOR_VERSION = 45;
    private static final short MINOR_VERSION = 3;
    private final short superClass;
    private final List interfaces;
    private final List fields;
    private final List methods;

    public ClassFile(String name, String sname) {
        this.constantPool = new ConstantPool();
        String n = JVMUtilities.getName(name);
        this.nameIndex = this.constantPool.put(new ClassIdentifier(n));
        n = JVMUtilities.getName(sname);
        this.superClass = this.constantPool.put(new ClassIdentifier(n));
        this.interfaces = new LinkedList();
        this.fields = new LinkedList();
        this.methods = new LinkedList();
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(3);
        out.writeShort(45);
        this.constantPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.nameIndex);
        out.writeShort(this.superClass);
        out.writeShort(this.interfaces.size());
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            out.writeShort(((Short)it.next()).shortValue());
        }
        out.writeShort(this.fields.size());
        it = this.fields.iterator();
        while (it.hasNext()) {
            ((FieldInfo)it.next()).write(out);
        }
        out.writeShort(this.methods.size());
        it = this.methods.iterator();
        while (it.hasNext()) {
            ((MethodInfo)it.next()).write(out);
        }
        out.writeShort(this.attributes.size());
        it = this.attributes.iterator();
        while (it.hasNext()) {
            ((AttributeInfo)it.next()).write(out);
        }
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public void setSuper() {
        this.accessFlags = (short)(this.accessFlags | 0x20);
    }

    public void setInterface() {
        this.accessFlags = (short)(this.accessFlags | 0x200);
    }

    public void setAbstract() {
        this.accessFlags = (short)(this.accessFlags | 0x400);
    }

    public void addInterface(String name) {
        String n = JVMUtilities.getName(name);
        this.interfaces.add(new Short(this.constantPool.put(new ClassIdentifier(n))));
    }

    public FieldInfo createField(String tp, String nm) {
        FieldInfo result = new FieldInfo(this.constantPool, tp, nm);
        this.fields.add(result);
        return result;
    }

    public MethodInfo createMethod(String rt, String nm, String[] pt) {
        MethodInfo result = new MethodInfo(this.constantPool, rt, nm, pt);
        this.methods.add(result);
        return result;
    }

    public void setInnerClassesAttribute(InnerClassesAttribute attr) {
        this.attributes.add(attr);
    }
}

