/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.StreamWrapper;

class FastpathParameterList
implements ParameterList {
    private final Object[] paramValues;

    FastpathParameterList(int paramCount) {
        this.paramValues = new Object[paramCount];
    }

    @Override
    public void registerOutParameter(int index, int sqlType) {
    }

    @Override
    public int getInParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        return 0;
    }

    @Override
    public int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int[] getTypeOIDs() {
        return null;
    }

    @Override
    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        throw new IllegalArgumentException("can't setLiteralParameter() on a fastpath parameter");
    }

    @Override
    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.paramValues[index - 1] = value;
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[index - 1] = new StreamWrapper(data, offset, length);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[index - 1] = new StreamWrapper(stream, length);
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        throw new IllegalArgumentException("can't setNull() on a v2 fastpath parameter");
    }

    @Override
    public String toString(int index) {
        if (index < 1 || index > this.paramValues.length) {
            throw new IllegalArgumentException("parameter " + index + " out of range");
        }
        return "<fastpath parameter>";
    }

    private void copyStream(PGStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.Send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.SendStream(wrapper.getStream(), wrapper.getLength());
    }

    void writeV2FastpathValue(int index, PGStream pgStream) throws IOException {
        if (this.paramValues[--index] instanceof StreamWrapper) {
            StreamWrapper wrapper = (StreamWrapper)this.paramValues[index];
            pgStream.SendInteger4(wrapper.getLength());
            this.copyStream(pgStream, wrapper);
        } else if (this.paramValues[index] instanceof byte[]) {
            byte[] data = (byte[])this.paramValues[index];
            pgStream.SendInteger4(data.length);
            pgStream.Send(data);
        } else if (this.paramValues[index] instanceof String) {
            byte[] data = pgStream.getEncoding().encode((String)this.paramValues[index]);
            pgStream.SendInteger4(data.length);
            pgStream.Send(data);
        } else {
            throw new IllegalArgumentException("don't know how to stream parameter " + index);
        }
    }

    @Override
    public ParameterList copy() {
        FastpathParameterList newCopy = new FastpathParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
    }
}

