/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

public abstract class NumberConvertor<T extends Number, U extends Number> {
    public static final NumberConvertor<Integer, Long> INT_TO_LONG = new NumberConvertor<Integer, Long>(){};
    public static final NumberConvertor<Short, Integer> SHORT_TO_INT = new NumberConvertor<Short, Integer>(){};

    public static <N extends Number> N convert(Number n, Class<N> clazz) {
        Number res;
        if (n.getClass() == clazz) {
            res = n;
        } else if (clazz == Short.class) {
            res = n.shortValue();
        } else if (clazz == Integer.class) {
            res = n.intValue();
        } else if (clazz == Long.class) {
            res = n.longValue();
        } else if (clazz == Byte.class) {
            res = n.byteValue();
        } else if (clazz == Double.class) {
            res = n.doubleValue();
        } else if (clazz == Float.class) {
            res = Float.valueOf(n.floatValue());
        } else {
            throw new IllegalArgumentException("unknown class: " + clazz);
        }
        return (N)((Number)clazz.cast(res));
    }
}

