/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import org.apache.commons.collections.Transformer;
import org.openconcerto.utils.ExceptionUtils;

public abstract class ExnTransformer<E, T, X extends Exception>
implements Transformer {
    @Override
    public final Object transform(Object input) {
        return this.transformCheckedWithExn(input, IllegalStateException.class);
    }

    public final <Y extends Exception> T transformCheckedWithExn(E input, Class<Y> exnClass) throws Y {
        try {
            return this.transformChecked(input);
        }
        catch (Exception e) {
            if (exnClass.isInstance(e)) {
                throw (Exception)exnClass.cast(e);
            }
            throw ExceptionUtils.createExn(exnClass, "executeChecked failed", e);
        }
    }

    public final <Y extends Exception, Z extends Exception, A extends Exception> T transformCheckedWithExn(E input, boolean wrapRT, Class<Y> exnClass, Class<Z> exnClass2, Class<A> exnClass3) throws Y, Z, A {
        try {
            return this.transformChecked(input);
        }
        catch (Exception e) {
            if (!wrapRT && e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (exnClass.isInstance(e)) {
                throw (Exception)exnClass.cast(e);
            }
            if (exnClass2 != null && exnClass2.isInstance(e)) {
                throw (Exception)exnClass2.cast(e);
            }
            if (exnClass3 != null && exnClass3.isInstance(e)) {
                throw (Exception)exnClass3.cast(e);
            }
            throw ExceptionUtils.createExn(exnClass, "executeChecked failed", e);
        }
    }

    public abstract T transformChecked(E var1) throws X;
}

