/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class SQLCreateTableBase<T extends SQLCreateTableBase<T>>
extends ChangeTable<T> {
    private String pk;
    private boolean tmp;

    public SQLCreateTableBase(SQLSyntax syntax, String name) {
        super(syntax, name);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.pk = null;
        this.tmp = false;
    }

    @Override
    public final T addColumn(String name, String definition) {
        return (T)((SQLCreateTableBase)this.addClause(String.valueOf(SQLBase.quoteIdentifier(name)) + " " + definition, ChangeTable.ClauseType.ADD_COL));
    }

    public final T setPrimaryKey(String ... fields) {
        return this.setPrimaryKey(Arrays.asList(fields));
    }

    public final T setPrimaryKey(List<String> fields) {
        this.checkPK();
        this.pk = fields.size() > 0 ? "PRIMARY KEY (" + CollectionUtils.join(fields, ",", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String input) {
                return SQLBase.quoteIdentifier(input);
            }
        }) + ")" : null;
        return (T)((SQLCreateTableBase)this.thisAsT());
    }

    protected void checkPK() {
    }

    @Override
    public String asString(String r) {
        return this.asString(r, true);
    }

    public final String asString(String rootName, boolean includeConstraint) {
        return this.asString(rootName, includeConstraint ? EnumSet.allOf(ChangeTable.ClauseType.class) : EnumSet.complementOf(EnumSet.of(ChangeTable.ClauseType.ADD_CONSTRAINT)));
    }

    @Override
    protected final String asString(String rootName, ChangeTable.ConcatStep step) {
        switch (step) {
            case ALTER_TABLE: {
                return this.asString(rootName, step.getTypes());
            }
            case ADD_INDEX: 
            case ADD_FOREIGN: {
                return ((AlterTable)new AlterTable(this.getSyntax(), this.getName()).mutateTo(this)).asString(rootName, step);
            }
        }
        return null;
    }

    private String asString(String rootName, Set<ChangeTable.ClauseType> types) {
        StringBuffer res = new StringBuffer(512);
        SQLName tableName = this.tmp ? new SQLName(this.getName()) : new SQLName(rootName, this.getName());
        ArrayList<String> genClauses = new ArrayList<String>(this.getClauses(tableName, types));
        this.modifyClauses(genClauses);
        if (this.pk != null && types.contains((Object)ChangeTable.ClauseType.ADD_COL)) {
            genClauses.add(this.pk);
        }
        if (types.contains((Object)ChangeTable.ClauseType.ADD_CONSTRAINT)) {
            genClauses.addAll(this.getForeignConstraints(rootName));
        }
        if (genClauses.size() > 0) {
            if (this.tmp) {
                res.append("CREATE TEMPORARY TABLE ");
            } else {
                res.append("CREATE TABLE ");
            }
            res.append(String.valueOf(tableName.quote()) + " (\n");
            res.append(CollectionUtils.join(genClauses, ",\n"));
            res.append(") ");
            res.append(this.getSyntax().getCreateTableSuffix());
            res.append(";");
        }
        this.outClausesAsString(res, tableName, types);
        return res.toString();
    }

    protected void modifyClauses(List<String> genClauses) {
    }
}

